/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.handler;

import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;
import org.unidal.maven.plugin.source.lines.entity.RootModel;
import org.unidal.maven.plugin.source.lines.transform.BaseVisitor;
import org.unidal.maven.plugin.source.pipeline.Source;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerAdaptor;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerContext;
import org.unidal.maven.plugin.source.pipeline.SourceScope;

public class LineCounter
extends SourceHandlerAdaptor {
    private RootModel m_root = new RootModel();

    @Override
    public void handleEnd(SourceHandlerContext ctx, SourceScope scope) {
        if (scope.isProject()) {
            this.m_root.accept(new CountAggregator());
            this.m_root.accept(new CountPrinter());
            System.out.println(this.m_root);
        }
        ctx.fireEnd(scope);
    }

    @Override
    public void handleStart(SourceHandlerContext ctx, SourceScope scope) {
        Source source;
        SourceScope parentScope;
        if (scope.isFile() && (parentScope = (source = ctx.source()).getParentScope()).isSource()) {
            ProjectModel project = this.m_root.findOrCreateProject(source.getModule().getName());
            ClassModel klass = project.findOrCreateClass(source.getPackage(), source.getClassName());
            if (parentScope.isTest()) {
                klass.setTest(true);
            }
            if (source.getSourceRoot().contains("/target/generated-")) {
                klass.setGenerated(true);
            }
        }
        ctx.fireStart(scope);
    }

    @Override
    public void handleLine(SourceHandlerContext ctx, String line) {
        Source source = ctx.source();
        SourceScope parentScope = source.getParentScope();
        if (parentScope.isSource()) {
            String str;
            ProjectModel project = this.m_root.findOrCreateProject(source.getModule().getName());
            ClassModel klass = project.findOrCreateClass(source.getPackage(), source.getClassName());
            CountModel count = klass.getCount();
            if (count == null) {
                count = new CountModel();
                klass.setCount(count);
            }
            if ((str = line.trim()).isEmpty()) {
                count.incEmpty();
            } else if (str.startsWith("//") || str.startsWith("/*")) {
                count.incComment();
                if (str.contains("/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */")) {
                    klass.setGenerated(true);
                }
            }
            count.incLines();
        }
    }

    private static class CountPrinter
    extends BaseVisitor {
        private CountPrinter() {
        }

        @Override
        public void visitProject(ProjectModel project) {
            int len = "<?xml version=\"1.0\" encoding=\"utf-8\"?>".length();
            System.out.println(project.getName() + ": " + project.getCount().toString().substring(len));
        }

        @Override
        public void visitRoot(RootModel root) {
            super.visitRoot(root);
            int len = "<?xml version=\"1.0\" encoding=\"utf-8\"?>".length();
            System.out.println("TOTAL: " + root.getCount().toString().substring(len));
        }
    }

    private static class CountAggregator
    extends BaseVisitor {
        private CountModel m_root;
        private CountModel m_project;

        private CountAggregator() {
        }

        @Override
        public void visitCount(CountModel count) {
            this.m_root.add(count);
            this.m_project.add(count);
        }

        @Override
        public void visitClass(ClassModel _class) {
            CountModel count = _class.getCount();
            count.incFiles();
            if (_class.isGenerated()) {
                count.incGeneratedFiles();
            }
            if (_class.isTest()) {
                count.incTestFiles();
            }
            super.visitClass(_class);
        }

        @Override
        public void visitProject(ProjectModel project) {
            this.m_project = new CountModel();
            super.visitProject(project);
            project.setCount(this.m_project);
        }

        @Override
        public void visitRoot(RootModel root) {
            this.m_root = new CountModel();
            super.visitRoot(root);
            root.setCount(this.m_root);
        }
    }
}

