/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.transform;

import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;
import org.unidal.maven.plugin.source.lines.entity.RootModel;
import org.xml.sax.Attributes;

public class DefaultXmlMaker {
    public ClassModel buildClass(Attributes attributes) {
        String _package = attributes.getValue("package");
        String _class = attributes.getValue("class");
        String generated = attributes.getValue("generated");
        String test = attributes.getValue("test");
        ClassModel class_ = new ClassModel(_package, _class);
        if (generated != null) {
            class_.setGenerated(this.convert(Boolean.class, generated, null));
        }
        if (test != null) {
            class_.setTest(this.convert(Boolean.class, test, null));
        }
        return class_;
    }

    public CountModel buildCount(Attributes attributes) {
        String lines = attributes.getValue("lines");
        String empty = attributes.getValue("empty");
        String comment = attributes.getValue("comment");
        String files = attributes.getValue("files");
        String generatedFiles = attributes.getValue("generated-files");
        String testFiles = attributes.getValue("test-files");
        CountModel count = new CountModel();
        if (lines != null) {
            count.setLines(this.convert(Integer.class, lines, 0));
        }
        if (empty != null) {
            count.setEmpty(this.convert(Integer.class, empty, 0));
        }
        if (comment != null) {
            count.setComment(this.convert(Integer.class, comment, 0));
        }
        if (files != null) {
            count.setFiles(this.convert(Integer.class, files, 0));
        }
        if (generatedFiles != null) {
            count.setGeneratedFiles(this.convert(Integer.class, generatedFiles, 0));
        }
        if (testFiles != null) {
            count.setTestFiles(this.convert(Integer.class, testFiles, 0));
        }
        return count;
    }

    public ProjectModel buildProject(Attributes attributes) {
        String name = attributes.getValue("name");
        ProjectModel project = new ProjectModel(name);
        return project;
    }

    public RootModel buildRoot(Attributes attributes) {
        RootModel root = new RootModel();
        return root;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

