/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.transform;

import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.maven.plugin.source.lines.IEntity;
import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;
import org.unidal.maven.plugin.source.lines.entity.RootModel;
import org.unidal.maven.plugin.source.lines.transform.DefaultLinker;
import org.unidal.maven.plugin.source.lines.transform.DefaultXmlMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXmlParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultXmlMaker m_maker = new DefaultXmlMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_root;
    private StringBuilder m_text = new StringBuilder(256);

    public <T extends IEntity<?>> T parse(Class<T> entityType, InputSource input) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(input, (DefaultHandler)this);
            this.m_linker.finish();
            if (entityType.isAssignableFrom(this.m_root.getClass())) {
                return (T)this.m_root;
            }
            throw new IllegalArgumentException(String.format("Expected %s, but was %s", entityType, this.m_root.getClass()));
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX Parser! " + e, e);
        }
        catch (SAXException e) {
            throw new IOException("Unable to parse XML! " + e, e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForClass(ClassModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"count".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under class!", qName));
        }
        CountModel count = this.m_maker.buildCount(attributes);
        this.m_linker.onCount(parentObj, count);
        this.m_objs.push(count);
        this.m_tags.push(qName);
    }

    private void parseForCount(CountModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForProject(ProjectModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("count".equals(qName)) {
            CountModel count = this.m_maker.buildCount(attributes);
            this.m_linker.onCount(parentObj, count);
            this.m_objs.push(count);
        } else if ("class".equals(qName)) {
            ClassModel class_ = this.m_maker.buildClass(attributes);
            this.m_linker.onClass(parentObj, class_);
            this.m_objs.push(class_);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under project!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForRoot(RootModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("count".equals(qName)) {
            CountModel count = this.m_maker.buildCount(attributes);
            this.m_linker.onCount(parentObj, count);
            this.m_objs.push(count);
        } else if ("project".equals(qName)) {
            ProjectModel project = this.m_maker.buildProject(attributes);
            this.m_linker.onProject(parentObj, project);
            this.m_objs.push(project);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under root!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("root".equals(qName)) {
            RootModel root;
            this.m_root = root = this.m_maker.buildRoot(attributes);
            this.m_objs.push(root);
            this.m_tags.push(qName);
        } else if ("count".equals(qName)) {
            CountModel count;
            this.m_root = count = this.m_maker.buildCount(attributes);
            this.m_objs.push(count);
            this.m_tags.push(qName);
        } else if ("project".equals(qName)) {
            ProjectModel project;
            this.m_root = project = this.m_maker.buildProject(attributes);
            this.m_objs.push(project);
            this.m_tags.push(qName);
        } else if ("class".equals(qName)) {
            ClassModel _class;
            this.m_root = _class = this.m_maker.buildClass(attributes);
            this.m_objs.push(_class);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof RootModel) {
                this.parseForRoot((RootModel)parent, tag, qName, attributes);
            } else if (parent instanceof CountModel) {
                this.parseForCount((CountModel)parent, tag, qName, attributes);
            } else if (parent instanceof ProjectModel) {
                this.parseForProject((ProjectModel)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof ClassModel)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForClass((ClassModel)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

