/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.pipeline;

import org.unidal.maven.plugin.source.pipeline.Source;
import org.unidal.maven.plugin.source.pipeline.SourceHandler;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerAdaptor;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerContext;
import org.unidal.maven.plugin.source.pipeline.SourcePipeline;
import org.unidal.maven.plugin.source.pipeline.SourceScope;

public class AbstractSourceHandlerContext
extends SourceHandlerAdaptor
implements SourceHandlerContext {
    private SourcePipeline m_pipeline;
    private Source m_source;
    AbstractSourceHandlerContext m_prev;
    AbstractSourceHandlerContext m_next;

    public AbstractSourceHandlerContext(SourcePipeline pipeline, Source source) {
        this.m_pipeline = pipeline;
        this.m_source = source;
    }

    @Override
    public void fireEnd(SourceScope scope) {
        if (this.m_next != null) {
            this.m_next.handler().handleEnd(this.m_next, scope);
        }
    }

    @Override
    public void fireLine(String line) {
        if (this.m_next != null) {
            this.m_next.handler().handleLine(this.m_next, line);
        }
    }

    @Override
    public void fireStart(SourceScope scope) {
        if (this.m_next != null) {
            this.m_next.handler().handleStart(this.m_next, scope);
        }
    }

    @Override
    public SourceHandler handler() {
        throw new UnsupportedOperationException("This should NOT happen!");
    }

    @Override
    public SourcePipeline pipeline() {
        return this.m_pipeline;
    }

    @Override
    public Source source() {
        return this.m_source;
    }
}

