/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.pipeline;

import java.io.File;
import java.util.Stack;
import org.apache.maven.project.MavenProject;
import org.unidal.maven.plugin.source.pipeline.DefaultSourcePipeline;
import org.unidal.maven.plugin.source.pipeline.Source;
import org.unidal.maven.plugin.source.pipeline.SourceScope;

public class DefaultSource
implements Source {
    private DefaultSourcePipeline m_pipeline;
    private MavenProject m_project;
    private MavenProject m_module;
    private String m_sourceRoot;
    private File m_folder;
    private String m_package;
    private String m_className;
    private File m_file;
    private String m_line;
    private Stack<SourceScope> m_scopes = new Stack();

    public DefaultSource() {
        this.m_pipeline = new DefaultSourcePipeline(this);
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public File getFile() {
        return this.m_file;
    }

    @Override
    public File getFolder() {
        return this.m_folder;
    }

    @Override
    public String getLine() {
        return this.m_line;
    }

    @Override
    public MavenProject getModule() {
        return this.m_module;
    }

    @Override
    public String getPackage() {
        return this.m_package;
    }

    @Override
    public SourceScope getParentScope() {
        if (this.m_scopes.size() > 1) {
            return (SourceScope)((Object)this.m_scopes.get(this.m_scopes.size() - 2));
        }
        return null;
    }

    @Override
    public MavenProject getProject() {
        return this.m_project;
    }

    @Override
    public SourceScope getScope() {
        return this.m_scopes.peek();
    }

    @Override
    public String getSourceRoot() {
        return this.m_sourceRoot;
    }

    @Override
    public DefaultSourcePipeline pipeline() {
        return this.m_pipeline;
    }

    public SourceScope pop() {
        return this.m_scopes.pop();
    }

    public void push(SourceScope scope) {
        this.m_scopes.push(scope);
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public void setFolder(File folder) {
        this.m_folder = folder;
    }

    public void setLine(String line) {
        this.m_line = line;
    }

    public void setModule(MavenProject module) {
        this.m_module = module;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public void setProject(MavenProject project) {
        this.m_project = project;
    }

    public void setSourceRoot(String sourceRoot) {
        this.m_sourceRoot = sourceRoot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSource:\r\n");
        sb.append("  scopes: ").append(this.m_scopes).append("\r\n");
        sb.append("  root: ").append(this.m_project.getName()).append("\r\n");
        sb.append("  current: ").append(this.m_module.getName()).append("\r\n");
        if (this.m_sourceRoot != null) {
            sb.append("  sourceRoot: ").append(this.m_sourceRoot).append("\r\n");
        }
        if (this.m_folder != null) {
            sb.append("  folder: ").append(this.m_folder).append("\r\n");
        }
        if (this.m_file != null) {
            sb.append("  file: ").append(this.m_file).append("\r\n");
        }
        if (this.m_package != null) {
            sb.append("  package: ").append(this.m_package).append("\r\n");
        }
        if (this.m_className != null) {
            sb.append("  class: ").append(this.m_className).append("\r\n");
        }
        return sb.toString();
    }
}

