/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.pipeline;

import org.unidal.maven.plugin.source.pipeline.AbstractSourceHandlerContext;
import org.unidal.maven.plugin.source.pipeline.Source;
import org.unidal.maven.plugin.source.pipeline.SourceHandler;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerAdaptor;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerContext;
import org.unidal.maven.plugin.source.pipeline.SourcePipeline;

public class DefaultSourcePipeline
extends SourceHandlerAdaptor
implements SourcePipeline {
    private Source m_source;
    private AbstractSourceHandlerContext m_head;
    private AbstractSourceHandlerContext m_tail;

    public DefaultSourcePipeline(Source source) {
        this.m_source = source;
        this.m_head = new HeadContext(this, this.m_source);
        this.m_head.m_next = this.m_tail = new TailContext(this, this.m_source);
        this.m_tail.m_prev = this.m_head;
    }

    @Override
    public void addLast(SourceHandler handler) {
        AbstractSourceHandlerContext prev;
        HandlerContext ctx = new HandlerContext(this, this.m_source, handler);
        ctx.m_prev = prev = this.m_tail.m_prev;
        ctx.m_next = this.m_tail;
        prev.m_next = ctx;
        this.m_tail.m_prev = ctx;
    }

    @Override
    protected SourceHandlerContext getContext(SourceHandlerContext ctx) {
        return this.m_head;
    }

    public AbstractSourceHandlerContext headContext() {
        return this.m_head;
    }

    private static class TailContext
    extends AbstractSourceHandlerContext {
        private SourceHandler m_handler = new SourceHandlerAdaptor();

        public TailContext(SourcePipeline pipeline, Source source) {
            super(pipeline, source);
        }

        @Override
        public SourceHandler handler() {
            return this.m_handler;
        }
    }

    private static class HeadContext
    extends AbstractSourceHandlerContext {
        public HeadContext(SourcePipeline pipeline, Source source) {
            super(pipeline, source);
        }
    }

    private static class HandlerContext
    extends AbstractSourceHandlerContext {
        private SourceHandler m_handler;

        public HandlerContext(SourcePipeline pipeline, Source source, SourceHandler handler) {
            super(pipeline, source);
            this.m_handler = handler;
        }

        @Override
        public SourceHandler handler() {
            return this.m_handler;
        }

        public String toString() {
            return String.format("%s[handler=%s]", this.getClass().getSimpleName(), this.m_handler);
        }
    }
}

