/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.pipeline;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.unidal.maven.plugin.source.pipeline.DefaultSource;
import org.unidal.maven.plugin.source.pipeline.SourceHandlerContext;
import org.unidal.maven.plugin.source.pipeline.SourceScope;

public class PipelineDriver {
    private void handleEnd(DefaultSource source, SourceHandlerContext ctx, SourceScope scope) {
        source.pop();
        source.pipeline().handleEnd(ctx, scope);
    }

    void handleFile(DefaultSource source, SourceHandlerContext ctx, SourceScope scope, Path path) {
        File file = path.toFile();
        String name = file.getName();
        source.setFolder(file.getParentFile());
        source.setFile(file);
        if (scope.isSource() && name.endsWith(".java")) {
            String relativePath = file.getParent().substring(source.getSourceRoot().length() + 1);
            String className = name.substring(0, name.length() - ".java".length());
            source.setPackage(relativePath.replace('/', '.'));
            source.setClassName(className);
        }
        this.handleStart(source, ctx, SourceScope.FILE);
        try {
            List<String> lines = Files.readAllLines(path);
            for (String line : lines) {
                source.setLine(line);
                source.pipeline().handleLine(ctx, line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.handleEnd(source, ctx, SourceScope.FILE);
    }

    private void handleModule(DefaultSource source, SourceHandlerContext ctx, MavenProject module) throws IOException {
        source.setModule(module);
        this.handleStart(source, ctx, SourceScope.MODULE);
        for (String sourceRoot : module.getCompileSourceRoots()) {
            this.handleSourceRoot(source, ctx, sourceRoot, SourceScope.SOURCE);
        }
        for (Resource resource : module.getResources()) {
            this.handleSourceRoot(source, ctx, resource.getDirectory(), SourceScope.RESOURCE);
        }
        for (String sourceRoot : module.getTestCompileSourceRoots()) {
            this.handleSourceRoot(source, ctx, sourceRoot, SourceScope.TEST_SOURCE);
        }
        for (Resource resource : module.getTestResources()) {
            this.handleSourceRoot(source, ctx, resource.getDirectory(), SourceScope.TEST_RESOURCE);
        }
        this.handleEnd(source, ctx, SourceScope.MODULE);
    }

    public void handleProject(DefaultSource source, SourceHandlerContext ctx, MavenProject project) throws IOException {
        source.setProject(project);
        this.handleStart(source, ctx, SourceScope.PROJECT);
        if ("pom".equals(project.getPackaging())) {
            for (MavenProject module : project.getCollectedProjects()) {
                this.handleModule(source, ctx, module);
            }
        } else {
            this.handleModule(source, ctx, project);
        }
        this.handleEnd(source, ctx, SourceScope.PROJECT);
    }

    private void handleSourceRoot(DefaultSource source, SourceHandlerContext ctx, String sourceRoot, SourceScope scope) throws IOException {
        File file = new File(sourceRoot);
        source.setSourceRoot(sourceRoot);
        this.handleStart(source, ctx, scope);
        if (file.exists() && file.isDirectory()) {
            Files.walk(file.toPath(), new FileVisitOption[0]).forEach(path -> {
                if (path.toFile().isFile()) {
                    this.handleFile(source, ctx, scope, (Path)path);
                }
            });
        }
        this.handleEnd(source, ctx, scope);
    }

    private void handleStart(DefaultSource source, SourceHandlerContext ctx, SourceScope scope) {
        source.push(scope);
        source.pipeline().handleStart(ctx, scope);
    }
}

