/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.pom;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Triple;

@Named
public class VersionMapping
implements Initializable,
LogEnabled {
    private Map<String, Triple<String, String, String>> m_latestVersions = new HashMap<String, Triple<String, String, String>>();
    private Logger m_logger;

    public void initialize() throws InitializationException {
        this.map("javax.servlet", "servlet-api", "2.5");
        this.map("javax.servlet", "jstl", "1.2");
        this.map("org.unidal.framework", "web-framework", "3.0.4");
        this.map("org.unidal.webres", "WebResServer", "1.2.1");
    }

    private void map(String groupId, String artifactId, String version) {
        this.map(artifactId, groupId, artifactId, version);
    }

    private void map(String id, String groupId, String artifactId, String version) {
        this.m_logger.info(String.format("%s => %s:%s:%s", id, groupId, artifactId, version));
        this.m_latestVersions.put(id, (Triple<String, String, String>)new Triple((Object)groupId, (Object)artifactId, (Object)version));
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Triple<String, String, String> findById(String id) {
        return this.m_latestVersions.get(id);
    }
}

