/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.property;

import java.io.IOException;
import org.unidal.maven.plugin.property.AbstractPropertyProvider;

public class ConsoleProvider
extends AbstractPropertyProvider {
    public ConsoleProvider(String ... mappings) {
        super(mappings);
    }

    @Override
    public String getProperty(String property, String defaultValue) {
        String prompt = this.map(property);
        String value = null;
        value = prompt != null && prompt.length() > 0 ? this.readLine(prompt, defaultValue) : this.readLine(property, defaultValue);
        return value;
    }

    private String readLine(String prompt, String defaultValue) {
        String value = null;
        try {
            while (value == null) {
                if (defaultValue == null) {
                    System.out.print(String.format("%s: ", prompt));
                } else {
                    System.out.print(String.format("%s[%s]: ", prompt, defaultValue));
                }
                System.out.flush();
                byte[] buffer = new byte[256];
                int size = 0;
                while (true) {
                    int i = System.in.read();
                    byte b = (byte)(i & 0xFF);
                    if (i == -1) {
                        if (size != 0) break;
                        --size;
                        break;
                    }
                    if (b == 13) continue;
                    if (b == 10) break;
                    buffer[size++] = b;
                }
                if (size < 0) {
                    value = defaultValue;
                    break;
                }
                if (size == 0) {
                    value = defaultValue;
                    continue;
                }
                value = new String(buffer, 0, size);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

