/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.unidal.maven.plugin.property.AbstractPropertyProvider;

public class PropertiesFileProvider
extends AbstractPropertyProvider {
    private Properties m_properties = new Properties();

    public PropertiesFileProvider(String propertiesFile, String ... mappings) {
        super(mappings);
        InputStream in = this.getClass().getResourceAsStream(propertiesFile);
        try {
            File file;
            if (in == null && (file = new File(propertiesFile)).canRead()) {
                in = new FileInputStream(file);
            }
            if (in == null) {
                throw new IOException(String.format("Can't find properties file(%s).", propertiesFile));
            }
            this.m_properties.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error when loading properties file(%s).", propertiesFile), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getProperty(String property, String defaultValue) {
        String name = this.map(property);
        String value = null;
        if (name != null) {
            if (name.length() > 0) {
                value = this.m_properties.getProperty(name);
            }
        } else {
            value = this.m_properties.getProperty(property);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

