/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unidal.maven.plugin.property.ConsoleProvider;
import org.unidal.maven.plugin.property.EnvironmentVariableProvider;
import org.unidal.maven.plugin.property.PropertiesFileProvider;
import org.unidal.maven.plugin.property.PropertyProvider;
import org.unidal.maven.plugin.property.SystemPropertyProvider;

public class PropertyProviders {
    public static StringPropertyAccessor forString() {
        return new StringPropertyAccessor();
    }

    public static class StringPropertyAccessor
    extends PropertyAccessor<StringPropertyAccessor> {
        public String getProperty(String property, String defaultValue) {
            String value = this.getStringProperty(property, defaultValue);
            return value;
        }
    }

    public static abstract class PropertyAccessor<T extends PropertyAccessor<T>> {
        private List<PropertyProvider> m_providers = new ArrayList<PropertyProvider>();

        public T fromConsole(String ... mappings) {
            this.m_providers.add(new ConsoleProvider(mappings));
            return (T)this;
        }

        public T fromEnv(String ... mappings) {
            this.m_providers.add(new EnvironmentVariableProvider(mappings));
            return (T)this;
        }

        public T fromProperties(String propertiesFile, String ... mappings) {
            this.m_providers.add(new PropertiesFileProvider(propertiesFile, mappings));
            return (T)this;
        }

        public T fromSystem(String ... mappings) {
            this.m_providers.add(new SystemPropertyProvider(mappings));
            return (T)this;
        }

        protected String getStringProperty(String property, String defaultValue) {
            PropertyProvider provider;
            String value = null;
            Iterator<PropertyProvider> iterator = this.m_providers.iterator();
            while (iterator.hasNext() && (value = (provider = iterator.next()).getProperty(property, defaultValue)) == null) {
            }
            return value;
        }
    }
}

