/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.unidal.helper.Splitters;

public class HelpMojo
extends AbstractMojo {
    private String goal;
    private PluginDescriptor m_pd;

    private void describeGoal(String goal) {
        MojoDescriptor md = this.m_pd.getMojo(goal);
        this.info("%s:%s", this.m_pd.getGoalPrefix(), md.getGoal());
        List parameters = md.getParameters();
        Collections.sort(parameters, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter o1, Parameter o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Parameter p : parameters) {
            if (!p.isEditable()) continue;
            this.info("   -D%-20s   - %s", p.getName(), p.getDescription());
            String d = p.getDefaultValue();
            if (d == null) continue;
            this.info("     %-20s     Default: [%s]", "", d);
        }
        this.info("", new Object[0]);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.m_pd = (PluginDescriptor)super.getPluginContext().get("pluginDescriptor");
        if (this.goal != null && this.goal.length() > 0) {
            List list = Splitters.by((char)',').noEmptyItem().trim().split(this.goal);
            for (String item : list) {
                this.describeGoal(item);
            }
        } else {
            this.showMojoList();
        }
    }

    private void showMojoList() {
        List mds = this.m_pd.getMojos();
        Collections.sort(mds, new Comparator<MojoDescriptor>(){

            @Override
            public int compare(MojoDescriptor o1, MojoDescriptor o2) {
                String g1 = o1.getGoal();
                String g2 = o2.getGoal();
                if (g1.equals("help")) {
                    return -1;
                }
                if (g2.equals("help")) {
                    return 1;
                }
                return g1.compareTo(g2);
            }
        });
        this.info("Usage:", new Object[0]);
        for (MojoDescriptor md : mds) {
            this.info("   %s:%-20s   - %s", this.m_pd.getGoalPrefix(), md.getGoal(), md.getDescription());
        }
        this.info("", new Object[0]);
    }

    private void info(String pattern, Object ... args) {
        this.getLog().info((CharSequence)String.format(pattern, args));
    }
}

