/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.framework.GenerationContext;
import org.unidal.codegen.framework.XslGenerator;
import org.unidal.maven.plugin.wizard.WizardMojoSupport;
import org.unidal.maven.plugin.wizard.meta.JdbcWizardBuilder;
import org.unidal.maven.plugin.wizard.meta.TableMeta;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Table;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.pom.JdbcPomBuilder;

public class JdbcMojo
extends WizardMojoSupport {
    private JdbcWizardBuilder m_wizardBuilder;
    private JdbcPomBuilder m_pomBuilder;
    private XslGenerator m_generator;
    private TableMeta m_tableMeta;
    private String outputDir;
    private String sourceDir;
    private String manifest;
    private Connection m_conn;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getProject();
        try {
            Wizard wizard = this.m_wizardBuilder.build(project);
            this.m_conn = this.m_wizardBuilder.getConnection();
            MetaGenerator generator = new MetaGenerator();
            for (Jdbc jdbc : wizard.getJdbcs()) {
                for (Group group : jdbc.getGroups()) {
                    generator.generate(group);
                }
            }
            this.generate(new File(this.manifest), this.sourceDir);
            this.m_pomBuilder.build(project.getFile(), wizard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error when generating model meta: " + e, e);
        }
    }

    public void generate(File manifest, String sourceDir) throws Exception {
        GenerationContext ctx = super.createContext(manifest, sourceDir);
        this.m_generator.generate(ctx);
    }

    @Override
    protected String getCodegenType() {
        return "jdbc";
    }

    private class MetaGenerator {
        private MetaGenerator() {
        }

        public void generate(Group group) throws SQLException, IOException {
            this.generateCodegenFile(group);
            this.generateModelFile(group);
            this.generateManifestFile(group);
        }

        private void generateCodegenFile(Group group) throws SQLException, IOException {
            List<Table> tables = group.getTables();
            Element entities = new Element("entities");
            File file = new File(JdbcMojo.this.outputDir, group.getName() + "-codegen.xml");
            Collections.sort(tables, new Comparator<Table>(){

                @Override
                public int compare(Table t1, Table t2) {
                    return t1.getName().compareTo(t2.getName());
                }
            });
            for (Table table : group.getTables()) {
                Element entity = JdbcMojo.this.m_tableMeta.getTableMeta(JdbcMojo.this.m_conn.getMetaData(), table.getName());
                entities.addContent((Content)entity);
            }
            this.resolveAliasConfliction(entities);
            Document doc = new Document(entities);
            doc.addContent(0, (Content)new Comment(" THIS FILE WAS GENERATED BY CODEGEN, DO NOT EDIT IT! "));
            this.saveDocument(doc, file);
        }

        private void generateManifestFile(Group group) throws IOException {
            String name = group.getName();
            File file = new File(JdbcMojo.this.outputDir, name + "-manifest.xml");
            if (!file.exists()) {
                Document doc = JdbcMojo.this.m_tableMeta.getManifest(name + "-codegen.xml", name + "-dal.xml");
                this.saveDocument(doc, file);
            }
        }

        private void generateModelFile(Group group) throws IOException {
            File file = new File(JdbcMojo.this.outputDir, group.getName() + "-dal.xml");
            if (!file.exists()) {
                Document doc = JdbcMojo.this.m_tableMeta.getModel(group.getPackage());
                this.saveDocument(doc, file);
            }
        }

        private void resolveAliasConfliction(Element entities) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            List children = entities.getChildren("entity");
            for (Element entity : children) {
                String alias = entity.getAttributeValue("alias");
                Integer count = (Integer)map.get(alias);
                if (count == null) {
                    map.put(alias, 1);
                    continue;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                map.put(alias, count);
                entity.setAttribute("alias", alias + count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveDocument(Document codegen, File file) throws IOException {
            File folder = file.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try (FileWriter writer = new FileWriter(file);){
                new XMLOutputter(Format.getPrettyFormat()).output(codegen, (Writer)writer);
                JdbcMojo.this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
            }
        }
    }
}

