/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.maven.plugin.wizard.WizardMojoSupport;
import org.unidal.maven.plugin.wizard.meta.ModelMeta;
import org.unidal.maven.plugin.wizard.meta.ModelWizardBuilder;
import org.unidal.maven.plugin.wizard.model.entity.Model;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.pom.ModelPomBuilder;

public class ModelMojo
extends WizardMojoSupport {
    private ModelWizardBuilder m_wizardBuilder;
    private ModelPomBuilder m_pomBuilder;
    private ModelMeta m_modelMeta;
    private String outputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getProject();
        try {
            Wizard wizard = this.m_wizardBuilder.build(project);
            MetaGenerator generator = new MetaGenerator();
            for (Model model : wizard.getModels()) {
                generator.generate(model);
            }
            this.m_pomBuilder.build(project.getFile(), wizard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error when generating model meta: " + e, e);
        }
    }

    @Override
    protected String getCodegenType() {
        return "model";
    }

    private class MetaGenerator {
        private MetaGenerator() {
        }

        public void generate(Model model) throws IOException {
            this.generateCodegenFile(model);
            this.generateModelFile(model);
            this.generateManifestFile(model);
        }

        private void generateCodegenFile(Model model) throws IOException {
            File sampleFile = new File(model.getSampleModel());
            Document doc = ModelMojo.this.m_modelMeta.getCodegen(new FileReader(sampleFile));
            File file = new File(ModelMojo.this.outputDir, model.getName() + "-codegen.xml");
            this.saveDocument(doc, file);
        }

        private void generateManifestFile(Model model) throws IOException {
            String name = model.getName();
            File manifestFile = new File(ModelMojo.this.outputDir, name + "-manifest.xml");
            Document manifestDoc = ModelMojo.this.m_modelMeta.getManifest(name + "-codegen.xml", name + "-model.xml");
            this.saveDocument(manifestDoc, manifestFile);
        }

        private void generateModelFile(Model model) throws IOException {
            File file = new File(ModelMojo.this.outputDir, model.getName() + "-model.xml");
            if (!file.exists()) {
                Document doc = ModelMojo.this.m_modelMeta.getModel(model.getPackage());
                this.saveDocument(doc, file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveDocument(Document codegen, File file) throws IOException {
            File folder = file.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try (FileWriter writer = new FileWriter(file);){
                new XMLOutputter(Format.getPrettyFormat()).output(codegen, (Writer)writer);
                ModelMojo.this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
            }
        }
    }
}

