/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.helper.Splitters;
import org.unidal.maven.plugin.pom.PomDelegate;

public class ProjectDependencyMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String scope;
    protected Boolean optional;
    protected Boolean withExclusions;

    protected Document modifyPom(PomDelegate b) {
        Document doc = b.openMavenDocument(this.m_project.getFile());
        Element project = doc.getRootElement();
        Element dependencies = b.findOrCreateChild(project, "dependencies");
        b.checkDependency(dependencies, this.groupId, this.artifactId, this.version, this.scope);
        if (this.withExclusions.booleanValue()) {
            String id;
            Element dependency = b.findDependency(dependencies, this.groupId, this.artifactId);
            while (!"end".equals(id = PropertyProviders.fromConsole().forString("exclusions", "Child dependency to exclude(groupId:artifactId, or 'end'):", null, null))) {
                List parts = Splitters.by((char)':').trim().split(id);
                if (parts.size() != 2) continue;
                b.checkExclusion(dependency, (String)parts.get(0), (String)parts.get(1));
            }
        }
        return doc;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepare();
        PomDelegate b = new PomDelegate();
        Document doc = this.modifyPom(b);
        try {
            if (b.isModified()) {
                this.saveXml(doc, this.m_project.getFile());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate pom.xml.", e);
        }
    }

    protected void prepare() {
        if (this.groupId == null) {
            this.groupId = PropertyProviders.fromConsole().forString("groupId", "Dependency group id:", null, null);
        }
        if (this.artifactId == null) {
            this.artifactId = PropertyProviders.fromConsole().forString("groupId", "Artifact id:", null, null);
        }
        if (this.version == null) {
            this.version = PropertyProviders.fromConsole().forString("groupId", "Version:", null, null);
        }
        if (this.scope == null) {
            this.scope = PropertyProviders.fromConsole().forString("scope", "Scope(compile, provided, runtime, test):", "compile", (PropertyProviders.IValidator)new PropertyProviders.IValidator<String>(){
                private List<String> m_scopes = Arrays.asList("compile", "provided", "runtime", "test");

                public boolean validate(String scope) {
                    return this.m_scopes.contains(scope);
                }
            });
            if ("compile".equals(this.scope)) {
                this.scope = null;
            }
        }
        if (this.optional == null) {
            this.optional = PropertyProviders.fromConsole().forBoolean("optional", "Is optional?", false);
        }
        if (this.withExclusions == null) {
            this.withExclusions = PropertyProviders.fromConsole().forBoolean("withExclusions", "With exclusion? ", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(Document doc, File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Format format = Format.getPrettyFormat().setIndent("   ");
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileWriter writer = new FileWriter(file);){
            outputter.output(doc, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
        }
    }
}

