/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.maven.plugin.pom.PomDelegate;

public class ProjectModuleMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String name;
    protected String packaging;

    protected Document createModulePom() {
        PomDelegate b = new PomDelegate();
        Document doc = b.createMavenDocument();
        Element project = doc.getRootElement();
        Element parent = b.findOrCreateChild(project, "parent");
        b.createChild(parent, "groupId", this.m_project.getGroupId());
        b.createChild(parent, "artifactId", this.m_project.getArtifactId());
        b.createChild(parent, "version", this.m_project.getVersion());
        b.createChild(parent, "relativePath", "../pom.xml");
        b.createChild(project, "modelVersion", "4.0.0");
        if (!this.groupId.equals(this.m_project.getGroupId())) {
            b.createChild(project, "groupId", this.groupId);
        }
        b.createChild(project, "artifactId", this.artifactId);
        if (this.version.length() > 0 && !this.version.equals(this.m_project.getVersion())) {
            b.createChild(project, "version", this.version);
        }
        b.createChild(project, "name", this.name);
        if (!this.packaging.equals("jar")) {
            b.createChild(project, "packaging", this.packaging);
        }
        return doc;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"pom".equals(this.m_project.getPackaging())) {
            throw new MojoFailureException("The project is not an POM project!");
        }
        this.prepare();
        File dir = new File(this.m_project.getBasedir(), this.artifactId);
        if (dir.exists() && new File(dir, "pom.xml").exists()) {
            throw new MojoFailureException(String.format("The project(%s) is already existed!", this.artifactId));
        }
        Document parentDoc = this.modifyParentPom();
        Document doc = this.createModulePom();
        try {
            this.saveXml(doc, new File(this.m_project.getBasedir(), this.artifactId + "/pom.xml"));
            this.saveXml(parentDoc, this.m_project.getFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate pom.xml.", e);
        }
    }

    protected String getProjectName(String artifactId) {
        StringBuilder sb = new StringBuilder(artifactId.length());
        StringTokenizer st = new StringTokenizer(artifactId, "- ");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (part.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(part.charAt(0)) + part.substring(1));
        }
        return sb.toString();
    }

    protected Document modifyParentPom() {
        PomDelegate b = new PomDelegate();
        Document doc = b.openMavenDocument(this.m_project.getFile());
        Element project = doc.getRootElement();
        Element modules = b.findOrCreateChild(project, "modules", "build", null);
        b.createChild(modules, "module", this.artifactId);
        return doc;
    }

    protected void prepare() {
        if (this.groupId == null) {
            this.groupId = PropertyProviders.fromConsole().forString("groupId", "Project group id:", this.m_project.getGroupId(), null);
        }
        if (this.artifactId == null) {
            this.artifactId = PropertyProviders.fromConsole().forString("groupId", "Project artifact id:", null, null);
        }
        if (this.version == null) {
            this.version = PropertyProviders.fromConsole().forString("groupId", "Project version:", "", null);
        }
        if (this.name == null) {
            this.name = PropertyProviders.fromConsole().forString("groupId", "Project name:", this.getProjectName(this.artifactId), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(Document doc, File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Format format = Format.getPrettyFormat().setIndent("   ");
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileWriter writer = new FileWriter(file);){
            outputter.output(doc, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
        }
    }
}

