/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.maven.plugin.pom.PomDelegate;

public class ProjectMojo
extends AbstractMojo {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String name;
    protected String packaging;
    protected File m_pomFile = new File("pom.xml");

    protected Document createPom() {
        PomDelegate b = new PomDelegate();
        Document doc = b.createMavenDocument();
        Element project = doc.getRootElement();
        b.createChild(project, "modelVersion", "4.0.0");
        b.createChild(project, "groupId", this.groupId);
        b.createChild(project, "artifactId", this.artifactId);
        b.createChild(project, "version", this.version);
        b.createChild(project, "name", this.name);
        b.createChild(project, "packaging", this.packaging);
        return doc;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.m_pomFile.exists()) {
            this.getLog().warn((CharSequence)"pom.xml file is already existed! SKIPPED");
            return;
        }
        this.prepare();
        Document doc = this.createPom();
        try {
            this.saveXml(doc, this.m_pomFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate pom.xml.", e);
        }
    }

    protected String getProjectName(String artifactId) {
        StringBuilder sb = new StringBuilder(artifactId.length());
        StringTokenizer st = new StringTokenizer(artifactId, "- ");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            if (part.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Character.toUpperCase(part.charAt(0)) + part.substring(1));
        }
        return sb.toString();
    }

    protected void prepare() {
        if (this.groupId == null) {
            this.groupId = PropertyProviders.fromConsole().forString("groupId", "Project group id:", null, null);
        }
        if (this.artifactId == null) {
            this.artifactId = PropertyProviders.fromConsole().forString("artifactId", "Project artifact id:", null, null);
        }
        if (this.version == null) {
            this.version = PropertyProviders.fromConsole().forString("version", "Project version:", null, null);
        }
        if (this.name == null) {
            this.name = PropertyProviders.fromConsole().forString("name", "Project name:", this.getProjectName(this.artifactId), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(Document doc, File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Format format = Format.getPrettyFormat().setIndent("   ");
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileWriter writer = new FileWriter(file);){
            outputter.output(doc, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
        }
    }
}

