/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.framework.GenerationContext;
import org.unidal.codegen.framework.XslGenerator;
import org.unidal.maven.plugin.wizard.WizardMojoSupport;
import org.unidal.maven.plugin.wizard.meta.WebAppWizardBuilder;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.pom.WebAppPomBuilder;

public class WebAppMojo
extends WizardMojoSupport {
    private WebAppWizardBuilder m_wizardBuilder;
    private WebAppPomBuilder m_pomBuilder;
    private XslGenerator m_generator;
    private String sourceDir;
    private String manifest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = this.getProject();
        if (project.getPackaging().equals("pom")) {
            throw new MojoFailureException("This wizard can not be run against POM project!");
        }
        try {
            Wizard wizard = this.m_wizardBuilder.build(project);
            this.generate(new File(this.manifest), this.sourceDir);
            this.m_pomBuilder.build(project.getFile(), wizard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error when generating code for webapp.", e);
        }
    }

    public void generate(File manifest, String sourceDir) throws Exception {
        GenerationContext ctx = super.createContext(manifest, sourceDir);
        this.m_generator.generate(ctx);
    }

    @Override
    protected String getCodegenType() {
        return "webapp";
    }
}

