/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.framework.GenerationContext;
import org.unidal.codegen.framework.GenerationContextSupport;

public abstract class WizardMojoSupport
extends AbstractMojo {
    private MavenProject m_project;
    private boolean verbose;
    private boolean debug;

    public GenerationContext createContext(File manifestFile, String sourceDir) throws IOException {
        String resourceBase = String.format("/META-INF/wizard/%s/xsl", this.getCodegenType());
        return new WizardMojoGenerationContext(resourceBase, manifestFile, sourceDir);
    }

    protected abstract String getCodegenType();

    public MavenProject getProject() {
        return this.m_project;
    }

    protected class WizardMojoGenerationContext
    extends GenerationContextSupport {
        private final File m_manifestXml;
        private String m_resourceBasePath;
        private AtomicInteger m_generatedFiles;

        public WizardMojoGenerationContext(String resourceBasePath, File manifestXml, String sourceDir) throws IOException {
            super(WizardMojoSupport.this.m_project.getBasedir());
            this.m_generatedFiles = new AtomicInteger();
            this.m_resourceBasePath = resourceBasePath;
            this.m_manifestXml = manifestXml;
            this.getProperties().put("src-main-java", sourceDir);
        }

        public void debug(String message) {
            if (WizardMojoSupport.this.debug) {
                this.info(message);
            }
        }

        public AtomicInteger getGeneratedFiles() {
            return this.m_generatedFiles;
        }

        public File getManifestXml() {
            return this.m_manifestXml;
        }

        protected URL getResource(String name) {
            String path = this.m_resourceBasePath + "/" + name;
            URL url = ((Object)((Object)this)).getClass().getResource(path);
            if (url != null) {
                return url;
            }
            throw new RuntimeException("Can't find resource: " + path);
        }

        public void info(String message) {
            WizardMojoSupport.this.getLog().info((CharSequence)message);
        }

        public void verbose(String message) {
            if (WizardMojoSupport.this.debug || WizardMojoSupport.this.verbose) {
                this.info(message);
            }
        }
    }
}

