/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.dom;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class DomAccessor {
    private boolean m_modifed;

    public Element createChild(Element parent, String name, String value) {
        Element child = new Element(name, this.getNamespace());
        if (value != null) {
            child.setText(value);
        }
        parent.addContent((Content)child);
        this.m_modifed = true;
        return child;
    }

    public Element findChild(Element parent, String name) {
        return parent.getChild(name, this.getNamespace());
    }

    public Element findElement(Element parent, String name, String value) {
        List children = parent.getContent();
        for (Object child : children) {
            Element e;
            if (!(child instanceof Element) || !(e = (Element)child).getName().equals(name) || !e.getNamespace().equals((Object)this.getNamespace()) || !value.equals(e.getValue())) continue;
            return e;
        }
        return null;
    }

    public Element findOrCreateChild(Element parent, String name) {
        return this.findOrCreateChild(parent, name, null, null);
    }

    public Element findOrCreateChild(Element parent, String name, int index) {
        Element child = parent.getChild(name, this.getNamespace());
        if (child == null) {
            child = new Element(name, this.getNamespace());
            parent.addContent(index, (Content)child);
            this.m_modifed = true;
        }
        return child;
    }

    public Element findOrCreateChild(Element parent, String name, String beforeElement, String afterElement) {
        Element child = parent.getChild(name, this.getNamespace());
        if (child == null) {
            int index = -1;
            child = new Element(name, this.getNamespace());
            if (beforeElement != null) {
                index = this.indexOfElement(parent, beforeElement);
            } else if (afterElement != null && (index = this.indexOfElement(parent, afterElement)) >= 0) {
                ++index;
            }
            if (index < 0) {
                parent.addContent((Content)child);
            } else {
                parent.addContent(index, (Content)child);
            }
            this.m_modifed = true;
        }
        return child;
    }

    protected Namespace getNamespace() {
        return null;
    }

    public int indexOfElement(Element parent, String name) {
        List children = parent.getContent();
        int index = 0;
        for (Object child : children) {
            Element e;
            if (child instanceof Element && (e = (Element)child).getName().equals(name) && e.getNamespace().equals((Object)this.getNamespace())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int indexOfLastElement(Element parent, String name) {
        List children = parent.getContent();
        int len = children.size();
        int lastIndex = -1;
        for (int i = 0; i < len; ++i) {
            Element e;
            Object child = children.get(i);
            if (!(child instanceof Element) || !(e = (Element)child).getName().equals(name) || !e.getNamespace().equals((Object)this.getNamespace())) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    public boolean isModified() {
        return this.m_modifed;
    }

    public Document loadDocument(File xmlFile) throws JDOMException, IOException {
        return new SAXBuilder().build(xmlFile);
    }

    public Document loadDocument(String xml) throws JDOMException, IOException {
        return new SAXBuilder().build((Reader)new StringReader(xml));
    }

    public String selectAttribute(Parent parent, String xpath, Object ... variables) throws JDOMException {
        XPath path = XPath.newInstance((String)xpath);
        this.setVariables(path, variables);
        Attribute attribute = (Attribute)path.selectSingleNode((Object)parent);
        return attribute.getValue();
    }

    public List<String> selectAttributes(Parent parent, String xpath, Object ... variables) throws JDOMException {
        XPath path = XPath.newInstance((String)xpath);
        this.setVariables(path, variables);
        List attributes = path.selectNodes((Object)parent);
        ArrayList<String> result = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            result.add(attribute.getValue());
        }
        return result;
    }

    public <S, T> List<T> selectNodes(Parent parent, String xpath, Function<S, T> function, Object ... variables) throws JDOMException {
        XPath path = XPath.newInstance((String)xpath);
        this.setVariables(path, variables);
        List nodes = path.selectNodes((Object)parent);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object node : nodes) {
            if (function != null) {
                result.add(function.apply(node));
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public void setModified(boolean modified) {
        this.m_modifed = modified;
    }

    private void setVariables(XPath path, Object ... variables) {
        int len = variables.length;
        if (len % 2 != 0) {
            throw new RuntimeException(String.format("Variables(%s) should be paired!", Arrays.asList(variables)));
        }
        for (int i = 0; i < len; i += 2) {
            path.setVariable(String.valueOf(variables[i]), variables[i + 1]);
        }
    }

    public static interface Function<S, T> {
        public T apply(S var1);
    }
}

