/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.meta;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.helper.Splitters;
import org.unidal.maven.plugin.wizard.model.WizardHelper;
import org.unidal.maven.plugin.wizard.model.entity.Manifest;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.xml.sax.SAXException;

abstract class AbstractWizardBuilder
implements LogEnabled {
    private MavenProject m_project;
    private Logger m_logger;

    AbstractWizardBuilder() {
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private String getWizardPackageName() {
        String defaultName = this.guessPackageName();
        if (defaultName == null) {
            ArrayList parts = new ArrayList();
            Splitters.by((char)'.').split(this.m_project.getGroupId(), parts);
            Splitters.by((char)'-').split(this.m_project.getArtifactId(), parts);
            StringBuilder sb = new StringBuilder(256);
            HashSet<String> done = new HashSet<String>();
            for (String part : parts) {
                if (done.contains(part)) continue;
                sb.append(part).append('.');
                done.add(part);
            }
            defaultName = sb.substring(0, sb.length() - 1);
        }
        PropertyProviders.ConsoleProvider console = PropertyProviders.fromConsole();
        String name = console.forString("project.package", "Please input project-level package name:", defaultName, null);
        return name;
    }

    protected String getDefaultPackageName(String groupId, String artifactId) {
        ArrayList parts = new ArrayList();
        Splitters.by((char)'.').split(groupId, parts);
        Splitters.by((char)'-').split(artifactId, parts);
        StringBuilder sb = new StringBuilder(256);
        HashSet<String> done = new HashSet<String>();
        for (String part : parts) {
            if (done.contains(part)) continue;
            sb.append(part).append('.');
            done.add(part);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String guessPackageName() {
        for (String sourceRoot : this.m_project.getCompileSourceRoots()) {
            final AtomicReference packageName = new AtomicReference();
            Scanners.forDir().scan(new File(sourceRoot), (Scanners.IMatcher)new Scanners.DirMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (path.endsWith("/build")) {
                        packageName.set(path.substring(0, path.length() - 6).replace('/', '.'));
                        return Scanners.IMatcher.Direction.MATCHED;
                    }
                    return Scanners.IMatcher.Direction.DOWN;
                }
            });
            if (packageName.get() == null) continue;
            return (String)packageName.get();
        }
        return null;
    }

    protected void initialize(MavenProject project) {
        this.m_project = project;
    }

    protected Wizard loadWizard() throws IOException, SAXException {
        Wizard wizard;
        File wizardFile = new File(this.m_project.getBasedir(), "src/main/resources/META-INF/wizard/wizard.xml");
        if (wizardFile.isFile()) {
            String content = Files.forIO().readFrom(wizardFile, "utf-8");
            wizard = WizardHelper.fromXml(content);
        } else {
            wizard = new Wizard();
            wizard.setPackage(this.getWizardPackageName());
        }
        return wizard;
    }

    protected void saveManifest() throws IOException {
        File manifestFile = new File(this.m_project.getBasedir(), "src/main/resources/META-INF/wizard/manifest.xml");
        if (!manifestFile.isFile()) {
            Manifest manifest = new Manifest();
            manifest.addFile(new org.unidal.maven.plugin.wizard.model.entity.File().setPath("wizard.xml"));
            Files.forIO().writeTo(manifestFile, manifest.toString());
            this.m_logger.info("File " + manifestFile.getCanonicalPath() + " created.");
        }
    }

    protected void saveWizard(Wizard wizard) throws IOException {
        File wizardFile = new File(this.m_project.getBasedir(), "src/main/resources/META-INF/wizard/wizard.xml");
        Files.forIO().writeTo(wizardFile, wizard.toString());
        if (!wizardFile.isFile()) {
            this.m_logger.info("File " + wizardFile.getCanonicalPath() + " created.");
        } else {
            this.m_logger.info("File " + wizardFile.getCanonicalPath() + " updated.");
        }
    }
}

