/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.meta;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.code.DefaultObfuscater;
import org.unidal.codegen.code.Obfuscater;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.helper.Codes;
import org.unidal.lookup.annotation.Named;
import org.unidal.maven.plugin.wizard.meta.AbstractWizardBuilder;
import org.unidal.maven.plugin.wizard.model.entity.Datasource;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Table;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.model.transform.BaseVisitor;
import org.xml.sax.SAXException;

@Named
public class JdbcWizardBuilder
extends AbstractWizardBuilder {
    private Obfuscater m_obfuscater = new DefaultObfuscater();
    private Connection m_conn;

    public Wizard build(MavenProject project) throws IOException, SAXException {
        super.initialize(project);
        Wizard wizard = super.loadWizard();
        wizard.accept(new Builder());
        super.saveWizard(wizard);
        super.saveManifest();
        return wizard;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    private class Builder
    extends BaseVisitor {
        private Wizard m_wizard;
        private Jdbc m_jdbc;

        private Builder() {
        }

        private List<String> getAvailableTableNames(Jdbc jdbc) {
            HashSet<String> existing = new HashSet<String>();
            for (Group group : jdbc.getGroups()) {
                for (Table table : group.getTables()) {
                    existing.add(table.getName());
                }
            }
            try {
                ArrayList<String> tables = new ArrayList<String>();
                ResultSet rs = JdbcWizardBuilder.this.m_conn.getMetaData().getTables(null, null, "%", new String[]{"TABLE"});
                while (rs.next()) {
                    String table = rs.getString("TABLE_NAME");
                    if (existing.contains(table)) continue;
                    tables.add(table);
                }
                rs.close();
                Collections.sort(tables);
                return tables;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private Connection setupConnection(Datasource ds) {
            Properties properties = new Properties();
            String password = ds.getPassword();
            if (password.startsWith("~{") && password.endsWith("}")) {
                password = Codes.forDecode().decode(password.substring(2, password.length() - 1));
            }
            properties.put("user", ds.getUser());
            properties.put("password", password);
            if (ds.getProperties() != null) {
                String[] pairs;
                for (String pair : pairs = ds.getProperties().split(Pattern.quote("&"))) {
                    int pos = pair.indexOf(61);
                    if (pos > 0) {
                        properties.put(pair.substring(0, pos), pair.substring(pos + 1));
                        continue;
                    }
                    System.err.println("invalid property: " + pair + " ignored.");
                }
            }
            try {
                Class.forName(ds.getDriver());
                return DriverManager.getConnection(ds.getUrl(), properties);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get connection due to " + e, e);
            }
        }

        @Override
        public void visitDatasource(Datasource ds) {
            PropertyProviders.ConsoleProvider console = PropertyProviders.fromConsole();
            ds.setDriver(console.forString("driver", "JDBC driver:", "com.mysql.cj.jdbc.Driver", null));
            ds.setUrl(console.forString("url", "JDBC URL:", "jdbc:mysql://localhost:3306/" + this.m_jdbc.getName(), null));
            ds.setUser(console.forString("user", "User:", null, null));
            String password = console.forString("password", "Password:(use '<none>' if no password)", null, null);
            if (password.equals("<none>")) {
                password = "";
            }
            try {
                ds.setPassword("~{" + JdbcWizardBuilder.this.m_obfuscater.encode(password) + "}");
            }
            catch (Exception e) {
                ds.setPassword(password);
            }
            String defaultProperties = "useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&useSSL=true";
            ds.setProperties(console.forString("properties", "Connection properties:", defaultProperties, null));
        }

        @Override
        public void visitGroup(final Group group) {
            if (group.getPackage() == null) {
                group.setPackage(this.m_jdbc.getPackage() + "." + group.getName().toLowerCase());
            }
            final List<String> availableNames = this.getAvailableTableNames(this.m_jdbc);
            final ArrayList<String> existingNames = new ArrayList<String>();
            PropertyProviders.ConsoleProvider console = PropertyProviders.fromConsole();
            System.out.println("Existing tables in group(" + group.getName() + ") is: ");
            for (Table table : group.getTables()) {
                existingNames.add(table.getName());
                System.out.println(table.getName());
            }
            System.out.println("Existing tables: " + existingNames);
            console.forString("table", "Select table name below, or '.' for end: ", availableNames, null, (PropertyProviders.IValidator)new PropertyProviders.IValidator<String>(){

                public boolean validate(String name) {
                    if (".".equals(name)) {
                        return true;
                    }
                    if (availableNames.contains(name)) {
                        existingNames.add(name);
                        availableNames.remove(name);
                        System.out.println("Tables selected: " + existingNames);
                        group.findOrCreateTable(name);
                    }
                    return false;
                }
            });
        }

        @Override
        public void visitJdbc(Jdbc jdbc) {
            Group group2;
            this.m_jdbc = jdbc;
            PropertyProviders.ConsoleProvider console = PropertyProviders.fromConsole();
            if (jdbc.getPackage() == null) {
                String packageName = console.forString("jdbc.package", "Jdbc Package:", this.m_wizard.getPackage() + ".dal", null);
                jdbc.setPackage(packageName);
            }
            if (jdbc.getDatasource() == null) {
                jdbc.setDatasource(new Datasource());
                this.visitDatasource(jdbc.getDatasource());
            }
            JdbcWizardBuilder.this.m_conn = this.setupConnection(jdbc.getDatasource());
            ArrayList<String> names = new ArrayList<String>();
            for (Group group2 : jdbc.getGroups()) {
                names.add(group2.getName());
            }
            String name = console.forString("group", "Select group name below or input a new one:", names, null, null);
            group2 = jdbc.findOrCreateGroup(name);
            this.visitGroup(group2);
        }

        @Override
        public void visitWizard(Wizard wizard) {
            this.m_wizard = wizard;
            ArrayList<String> names = new ArrayList<String>();
            for (Jdbc jdbc : wizard.getJdbcs()) {
                names.add(jdbc.getName());
            }
            PropertyProviders.ConsoleProvider console = PropertyProviders.fromConsole();
            String name = console.forString("datasource", "Select datasource below or input a new one:", names, null, null);
            Jdbc jdbc = wizard.findJdbc(name);
            if (jdbc == null) {
                jdbc = new Jdbc(name);
                wizard.addJdbc(jdbc);
            }
            this.visitJdbc(jdbc);
        }
    }
}

