/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.unidal.maven.plugin.wizard.model.IEntity;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.model.transform.DefaultXmlBuilder;
import org.unidal.maven.plugin.wizard.model.transform.DefaultXmlParser;
import org.xml.sax.InputSource;

public class WizardHelper {
    public static String asXml(IEntity<?> entity) {
        return new DefaultXmlBuilder().build(entity);
    }

    public static <T extends IEntity<T>> T fromXml(Class<T> entityType, InputStream in) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(WizardHelper.withoutBom(in)));
    }

    public static <T extends IEntity<T>> T fromXml(Class<T> entityType, String xml) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(new StringReader(xml)));
    }

    public static Wizard fromXml(InputStream in) throws IOException {
        return WizardHelper.fromXml(Wizard.class, in);
    }

    public static Wizard fromXml(String xml) throws IOException {
        return WizardHelper.fromXml(Wizard.class, xml);
    }

    private static InputStream withoutBom(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in.mark(3);
        if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
            in.reset();
        }
        return in;
    }
}

