/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.maven.plugin.wizard.model.BaseEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Table;

public class Group
extends BaseEntity<Group> {
    private String m_name;
    private String m_package;
    private List<Table> m_tables = new ArrayList<Table>();

    public Group() {
    }

    public Group(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitGroup(this);
    }

    public Group addTable(Table table) {
        this.m_tables.add(table);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group _o = (Group)obj;
            return this.equals(this.getName(), _o.getName());
        }
        return false;
    }

    public Table findTable(String name) {
        for (Table table : this.m_tables) {
            if (!this.equals(table.getName(), name)) continue;
            return table;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findOrCreateTable(String name) {
        List<Table> list = this.m_tables;
        synchronized (list) {
            for (Table table : this.m_tables) {
                if (!this.equals(table.getName(), name)) continue;
                return table;
            }
            Table table = new Table(name);
            this.m_tables.add(table);
            return table;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getPackage() {
        return this.m_package;
    }

    public List<Table> getTables() {
        return this.m_tables;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(Group other) {
        this.assertAttributeEquals(other, "group", "name", this.m_name, other.getName());
        if (other.getPackage() != null) {
            this.m_package = other.getPackage();
        }
    }

    public Table removeTable(String name) {
        int len = this.m_tables.size();
        for (int i = 0; i < len; ++i) {
            Table table = this.m_tables.get(i);
            if (!this.equals(table.getName(), name)) continue;
            return this.m_tables.remove(i);
        }
        return null;
    }

    public Group setName(String name) {
        this.m_name = name;
        return this;
    }

    public Group setPackage(String _package) {
        this.m_package = _package;
        return this;
    }
}

