/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.maven.plugin.wizard.model.BaseEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Datasource;
import org.unidal.maven.plugin.wizard.model.entity.Group;

public class Jdbc
extends BaseEntity<Jdbc> {
    private String m_package;
    private String m_name;
    private Datasource m_datasource;
    private List<Group> m_groups = new ArrayList<Group>();

    public Jdbc() {
    }

    public Jdbc(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitJdbc(this);
    }

    public Jdbc addGroup(Group group) {
        this.m_groups.add(group);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Jdbc) {
            Jdbc _o = (Jdbc)obj;
            return this.equals(this.getName(), _o.getName());
        }
        return false;
    }

    public Group findGroup(String name) {
        for (Group group : this.m_groups) {
            if (!this.equals(group.getName(), name)) continue;
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findOrCreateGroup(String name) {
        List<Group> list = this.m_groups;
        synchronized (list) {
            for (Group group : this.m_groups) {
                if (!this.equals(group.getName(), name)) continue;
                return group;
            }
            Group group = new Group(name);
            this.m_groups.add(group);
            return group;
        }
    }

    public Datasource getDatasource() {
        return this.m_datasource;
    }

    public List<Group> getGroups() {
        return this.m_groups;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPackage() {
        return this.m_package;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(Jdbc other) {
        this.assertAttributeEquals(other, "jdbc", "name", this.m_name, other.getName());
        if (other.getPackage() != null) {
            this.m_package = other.getPackage();
        }
    }

    public Group removeGroup(String name) {
        int len = this.m_groups.size();
        for (int i = 0; i < len; ++i) {
            Group group = this.m_groups.get(i);
            if (!this.equals(group.getName(), name)) continue;
            return this.m_groups.remove(i);
        }
        return null;
    }

    public Jdbc setDatasource(Datasource datasource) {
        this.m_datasource = datasource;
        return this;
    }

    public Jdbc setName(String name) {
        this.m_name = name;
        return this;
    }

    public Jdbc setPackage(String _package) {
        this.m_package = _package;
        return this;
    }
}

