/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.maven.plugin.wizard.model.BaseEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Page;

public class Module
extends BaseEntity<Module> {
    private String m_name;
    private String m_path;
    private Boolean m_default;
    private String m_package;
    private List<Page> m_pages = new ArrayList<Page>();

    public Module() {
    }

    public Module(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitModule(this);
    }

    public Module addPage(Page page) {
        this.m_pages.add(page);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Module) {
            Module _o = (Module)obj;
            return this.equals(this.getName(), _o.getName());
        }
        return false;
    }

    public Page findPage(String name) {
        for (Page page : this.m_pages) {
            if (!this.equals(page.getName(), name)) continue;
            return page;
        }
        return null;
    }

    public Boolean getDefault() {
        return this.m_default;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPackage() {
        return this.m_package;
    }

    public List<Page> getPages() {
        return this.m_pages;
    }

    public String getPath() {
        return this.m_path;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    public boolean isDefault() {
        return this.m_default != null && this.m_default != false;
    }

    @Override
    public void mergeAttributes(Module other) {
        this.assertAttributeEquals(other, "module", "name", this.m_name, other.getName());
        if (other.getPath() != null) {
            this.m_path = other.getPath();
        }
        if (other.getDefault() != null) {
            this.m_default = other.getDefault();
        }
        if (other.getPackage() != null) {
            this.m_package = other.getPackage();
        }
    }

    public Page removePage(String name) {
        int len = this.m_pages.size();
        for (int i = 0; i < len; ++i) {
            Page page = this.m_pages.get(i);
            if (!this.equals(page.getName(), name)) continue;
            return this.m_pages.remove(i);
        }
        return null;
    }

    public Module setDefault(Boolean _default) {
        this.m_default = _default;
        return this;
    }

    public Module setName(String name) {
        this.m_name = name;
        return this;
    }

    public Module setPackage(String _package) {
        this.m_package = _package;
        return this;
    }

    public Module setPath(String path) {
        this.m_path = path;
        return this;
    }
}

