/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.maven.plugin.wizard.model.BaseEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Module;

public class Webapp
extends BaseEntity<Webapp> {
    private String m_package;
    private String m_name;
    private Boolean m_module;
    private String m_language;
    private List<Module> m_modules = new ArrayList<Module>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitWebapp(this);
    }

    public Webapp addModule(Module module) {
        this.m_modules.add(module);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Webapp) {
            Webapp _o = (Webapp)obj;
            if (!this.equals(this.getPackage(), _o.getPackage())) {
                return false;
            }
            if (!this.equals(this.getName(), _o.getName())) {
                return false;
            }
            if (!this.equals(this.getModule(), _o.getModule())) {
                return false;
            }
            if (!this.equals(this.getLanguage(), _o.getLanguage())) {
                return false;
            }
            return this.equals(this.getModules(), _o.getModules());
        }
        return false;
    }

    public Module findModule(String name) {
        for (Module module : this.m_modules) {
            if (!this.equals(module.getName(), name)) continue;
            return module;
        }
        return null;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public Boolean getModule() {
        return this.m_module;
    }

    public List<Module> getModules() {
        return this.m_modules;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPackage() {
        return this.m_package;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_package == null ? 0 : this.m_package.hashCode());
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        hash = hash * 31 + (this.m_module == null ? 0 : this.m_module.hashCode());
        hash = hash * 31 + (this.m_language == null ? 0 : this.m_language.hashCode());
        for (Module e : this.m_modules) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        return hash;
    }

    public boolean isModule() {
        return this.m_module != null && this.m_module != false;
    }

    @Override
    public void mergeAttributes(Webapp other) {
        if (other.getPackage() != null) {
            this.m_package = other.getPackage();
        }
        if (other.getName() != null) {
            this.m_name = other.getName();
        }
        if (other.getModule() != null) {
            this.m_module = other.getModule();
        }
        if (other.getLanguage() != null) {
            this.m_language = other.getLanguage();
        }
    }

    public Module removeModule(String name) {
        int len = this.m_modules.size();
        for (int i = 0; i < len; ++i) {
            Module module = this.m_modules.get(i);
            if (!this.equals(module.getName(), name)) continue;
            return this.m_modules.remove(i);
        }
        return null;
    }

    public Webapp setLanguage(String language) {
        this.m_language = language;
        return this;
    }

    public Webapp setModule(Boolean module) {
        this.m_module = module;
        return this;
    }

    public Webapp setName(String name) {
        this.m_name = name;
        return this;
    }

    public Webapp setPackage(String _package) {
        this.m_package = _package;
        return this;
    }
}

