/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.maven.plugin.wizard.model.BaseEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Manifest;
import org.unidal.maven.plugin.wizard.model.entity.Model;
import org.unidal.maven.plugin.wizard.model.entity.Webapp;

public class Wizard
extends BaseEntity<Wizard> {
    private String m_package;
    private Manifest m_manifest;
    private Webapp m_webapp;
    private List<Jdbc> m_jdbcs = new ArrayList<Jdbc>();
    private List<Model> m_models = new ArrayList<Model>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitWizard(this);
    }

    public Wizard addJdbc(Jdbc jdbc) {
        this.m_jdbcs.add(jdbc);
        return this;
    }

    public Wizard addModel(Model model) {
        this.m_models.add(model);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Wizard) {
            Wizard _o = (Wizard)obj;
            if (!this.equals(this.getPackage(), _o.getPackage())) {
                return false;
            }
            if (!this.equals(this.getManifest(), _o.getManifest())) {
                return false;
            }
            if (!this.equals(this.getWebapp(), _o.getWebapp())) {
                return false;
            }
            if (!this.equals(this.getJdbcs(), _o.getJdbcs())) {
                return false;
            }
            return this.equals(this.getModels(), _o.getModels());
        }
        return false;
    }

    public Jdbc findJdbc(String name) {
        for (Jdbc jdbc : this.m_jdbcs) {
            if (!this.equals(jdbc.getName(), name)) continue;
            return jdbc;
        }
        return null;
    }

    public Model findModel(String name) {
        for (Model model : this.m_models) {
            if (!this.equals(model.getName(), name)) continue;
            return model;
        }
        return null;
    }

    public List<Jdbc> getJdbcs() {
        return this.m_jdbcs;
    }

    public Manifest getManifest() {
        return this.m_manifest;
    }

    public List<Model> getModels() {
        return this.m_models;
    }

    public String getPackage() {
        return this.m_package;
    }

    public Webapp getWebapp() {
        return this.m_webapp;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_package == null ? 0 : this.m_package.hashCode());
        hash = hash * 31 + (this.m_manifest == null ? 0 : this.m_manifest.hashCode());
        hash = hash * 31 + (this.m_webapp == null ? 0 : this.m_webapp.hashCode());
        for (Jdbc jdbc : this.m_jdbcs) {
            hash = hash * 31 + (jdbc == null ? 0 : jdbc.hashCode());
        }
        for (Model model : this.m_models) {
            hash = hash * 31 + (model == null ? 0 : model.hashCode());
        }
        return hash;
    }

    @Override
    public void mergeAttributes(Wizard other) {
        if (other.getPackage() != null) {
            this.m_package = other.getPackage();
        }
    }

    public Jdbc removeJdbc(String name) {
        int len = this.m_jdbcs.size();
        for (int i = 0; i < len; ++i) {
            Jdbc jdbc = this.m_jdbcs.get(i);
            if (!this.equals(jdbc.getName(), name)) continue;
            return this.m_jdbcs.remove(i);
        }
        return null;
    }

    public Model removeModel(String name) {
        int len = this.m_models.size();
        for (int i = 0; i < len; ++i) {
            Model model = this.m_models.get(i);
            if (!this.equals(model.getName(), name)) continue;
            return this.m_models.remove(i);
        }
        return null;
    }

    public Wizard setManifest(Manifest manifest) {
        this.m_manifest = manifest;
        return this;
    }

    public Wizard setPackage(String _package) {
        this.m_package = _package;
        return this;
    }

    public Wizard setWebapp(Webapp webapp) {
        this.m_webapp = webapp;
        return this;
    }
}

