/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.transform;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.unidal.maven.plugin.wizard.model.IEntity;
import org.unidal.maven.plugin.wizard.model.IVisitor;
import org.unidal.maven.plugin.wizard.model.entity.Datasource;
import org.unidal.maven.plugin.wizard.model.entity.File;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Manifest;
import org.unidal.maven.plugin.wizard.model.entity.Model;
import org.unidal.maven.plugin.wizard.model.entity.Module;
import org.unidal.maven.plugin.wizard.model.entity.Page;
import org.unidal.maven.plugin.wizard.model.entity.Table;
import org.unidal.maven.plugin.wizard.model.entity.Webapp;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this.m_compact = compact;
    }

    public String build(IEntity<?> entity) {
        this.m_sb = new StringBuilder(8192);
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = this.toString(value);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (Object item : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(value, i);
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    protected void tagWithText(String name, String text, Map<String, String> attributes) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        if (attributes != null) {
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void tagWithText(String name, String text, Object ... nameValues) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void element(String name, String text, String defaultValue, boolean escape) {
        if (text == null || text.equals(defaultValue)) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name).append(">");
        if (escape) {
            this.m_sb.append(this.escape(text, true));
        } else {
            this.m_sb.append("<![CDATA[").append(text).append("]]>");
        }
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    @Override
    public void visitDatasource(Datasource datasource) {
        this.startTag("datasource", null, "name", datasource.getName());
        this.element("driver", datasource.getDriver(), null, true);
        this.element("url", datasource.getUrl(), null, true);
        this.element("user", datasource.getUser(), null, true);
        this.element("password", datasource.getPassword(), null, true);
        this.element("properties", datasource.getProperties(), null, true);
        this.endTag("datasource");
    }

    @Override
    public void visitFile(File file) {
        this.startTag("file", true, null, "path", file.getPath());
    }

    @Override
    public void visitGroup(Group group) {
        this.startTag("group", null, "name", group.getName(), "package", group.getPackage());
        if (!group.getTables().isEmpty()) {
            for (Table table : group.getTables()) {
                table.accept(this.m_visitor);
            }
        }
        this.endTag("group");
    }

    @Override
    public void visitJdbc(Jdbc jdbc) {
        this.startTag("jdbc", null, "package", jdbc.getPackage(), "name", jdbc.getName());
        if (jdbc.getDatasource() != null) {
            jdbc.getDatasource().accept(this.m_visitor);
        }
        if (!jdbc.getGroups().isEmpty()) {
            for (Group group : jdbc.getGroups()) {
                group.accept(this.m_visitor);
            }
        }
        this.endTag("jdbc");
    }

    @Override
    public void visitManifest(Manifest manifest) {
        this.startTag("manifest", null, new Object[0]);
        if (!manifest.getFiles().isEmpty()) {
            for (File file : manifest.getFiles()) {
                file.accept(this.m_visitor);
            }
        }
        this.endTag("manifest");
    }

    @Override
    public void visitModel(Model model) {
        this.startTag("model", null, "package", model.getPackage(), "name", model.getName());
        this.element("sample-model", model.getSampleModel(), null, true);
        this.endTag("model");
    }

    @Override
    public void visitModule(Module module) {
        this.startTag("module", null, "name", module.getName(), "path", module.getPath(), "default", module.getDefault(), "package", module.getPackage());
        if (!module.getPages().isEmpty()) {
            for (Page page : module.getPages()) {
                page.accept(this.m_visitor);
            }
        }
        this.endTag("module");
    }

    @Override
    public void visitPage(Page page) {
        this.startTag("page", null, "name", page.getName(), "path", page.getPath(), "default", page.getDefault(), "package", page.getPackage(), "title", page.getTitle(), "standalone", page.getStandalone(), "view", page.getView());
        this.element("description", page.getDescription(), null, true);
        this.endTag("page");
    }

    @Override
    public void visitTable(Table table) {
        this.startTag("table", true, null, "name", table.getName());
    }

    @Override
    public void visitWebapp(Webapp webapp) {
        this.startTag("webapp", null, "package", webapp.getPackage(), "name", webapp.getName(), "module", webapp.getModule(), "language", webapp.getLanguage());
        if (!webapp.getModules().isEmpty()) {
            for (Module module : webapp.getModules()) {
                module.accept(this.m_visitor);
            }
        }
        this.endTag("webapp");
    }

    @Override
    public void visitWizard(Wizard wizard) {
        this.startTag("wizard", null, "package", wizard.getPackage());
        if (wizard.getManifest() != null) {
            wizard.getManifest().accept(this.m_visitor);
        }
        if (wizard.getWebapp() != null) {
            wizard.getWebapp().accept(this.m_visitor);
        }
        if (!wizard.getJdbcs().isEmpty()) {
            for (Jdbc jdbc : wizard.getJdbcs()) {
                jdbc.accept(this.m_visitor);
            }
        }
        if (!wizard.getModels().isEmpty()) {
            for (Model model : wizard.getModels()) {
                model.accept(this.m_visitor);
            }
        }
        this.endTag("wizard");
    }
}

