/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.transform;

import org.unidal.maven.plugin.wizard.model.entity.Datasource;
import org.unidal.maven.plugin.wizard.model.entity.File;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Manifest;
import org.unidal.maven.plugin.wizard.model.entity.Model;
import org.unidal.maven.plugin.wizard.model.entity.Module;
import org.unidal.maven.plugin.wizard.model.entity.Page;
import org.unidal.maven.plugin.wizard.model.entity.Table;
import org.unidal.maven.plugin.wizard.model.entity.Webapp;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.xml.sax.Attributes;

public class DefaultXmlMaker {
    public Datasource buildDatasource(Attributes attributes) {
        String name = attributes.getValue("name");
        Datasource datasource = new Datasource(name);
        return datasource;
    }

    public File buildFile(Attributes attributes) {
        String path = attributes.getValue("path");
        File file = new File();
        if (path != null) {
            file.setPath(path);
        }
        return file;
    }

    public Group buildGroup(Attributes attributes) {
        String name = attributes.getValue("name");
        String _package = attributes.getValue("package");
        Group group = new Group(name);
        if (_package != null) {
            group.setPackage(_package);
        }
        return group;
    }

    public Jdbc buildJdbc(Attributes attributes) {
        String _package = attributes.getValue("package");
        String name = attributes.getValue("name");
        Jdbc jdbc = new Jdbc(name);
        if (_package != null) {
            jdbc.setPackage(_package);
        }
        return jdbc;
    }

    public Manifest buildManifest(Attributes attributes) {
        Manifest manifest = new Manifest();
        return manifest;
    }

    public Model buildModel(Attributes attributes) {
        String _package = attributes.getValue("package");
        String name = attributes.getValue("name");
        Model model = new Model(name);
        if (_package != null) {
            model.setPackage(_package);
        }
        return model;
    }

    public Module buildModule(Attributes attributes) {
        String name = attributes.getValue("name");
        String path = attributes.getValue("path");
        String _default = attributes.getValue("default");
        String _package = attributes.getValue("package");
        Module module = new Module(name);
        if (path != null) {
            module.setPath(path);
        }
        if (_default != null) {
            module.setDefault(this.convert(Boolean.class, _default, null));
        }
        if (_package != null) {
            module.setPackage(_package);
        }
        return module;
    }

    public Page buildPage(Attributes attributes) {
        String name = attributes.getValue("name");
        String path = attributes.getValue("path");
        String _default = attributes.getValue("default");
        String _package = attributes.getValue("package");
        String title = attributes.getValue("title");
        String standalone = attributes.getValue("standalone");
        String view = attributes.getValue("view");
        Page page = new Page(name);
        if (path != null) {
            page.setPath(path);
        }
        if (_default != null) {
            page.setDefault(this.convert(Boolean.class, _default, null));
        }
        if (_package != null) {
            page.setPackage(_package);
        }
        if (title != null) {
            page.setTitle(title);
        }
        if (standalone != null) {
            page.setStandalone(this.convert(Boolean.class, standalone, null));
        }
        if (view != null) {
            page.setView(view);
        }
        return page;
    }

    public Table buildTable(Attributes attributes) {
        String name = attributes.getValue("name");
        Table table = new Table(name);
        return table;
    }

    public Webapp buildWebapp(Attributes attributes) {
        String _package = attributes.getValue("package");
        String name = attributes.getValue("name");
        String module = attributes.getValue("module");
        String language = attributes.getValue("language");
        Webapp webapp = new Webapp();
        if (_package != null) {
            webapp.setPackage(_package);
        }
        if (name != null) {
            webapp.setName(name);
        }
        if (module != null) {
            webapp.setModule(this.convert(Boolean.class, module, null));
        }
        if (language != null) {
            webapp.setLanguage(language);
        }
        return webapp;
    }

    public Wizard buildWizard(Attributes attributes) {
        String _package = attributes.getValue("package");
        Wizard wizard = new Wizard();
        if (_package != null) {
            wizard.setPackage(_package);
        }
        return wizard;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

