/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.model.transform;

import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.maven.plugin.wizard.model.IEntity;
import org.unidal.maven.plugin.wizard.model.entity.Datasource;
import org.unidal.maven.plugin.wizard.model.entity.File;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Manifest;
import org.unidal.maven.plugin.wizard.model.entity.Model;
import org.unidal.maven.plugin.wizard.model.entity.Module;
import org.unidal.maven.plugin.wizard.model.entity.Page;
import org.unidal.maven.plugin.wizard.model.entity.Table;
import org.unidal.maven.plugin.wizard.model.entity.Webapp;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.model.transform.DefaultLinker;
import org.unidal.maven.plugin.wizard.model.transform.DefaultXmlMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXmlParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultXmlMaker m_maker = new DefaultXmlMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_root;
    private StringBuilder m_text = new StringBuilder(256);

    public <T extends IEntity<?>> T parse(Class<T> entityType, InputSource input) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(input, (DefaultHandler)this);
            this.m_linker.finish();
            if (entityType.isAssignableFrom(this.m_root.getClass())) {
                return (T)this.m_root;
            }
            throw new IllegalArgumentException(String.format("Expected %s, but was %s", entityType, this.m_root.getClass()));
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX Parser! " + e, e);
        }
        catch (SAXException e) {
            throw new IOException("Unable to parse XML! " + e, e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof Page) {
                Page page = (Page)currentObj;
                if ("description".equals(currentTag)) {
                    page.setDescription(this.getText());
                }
            } else if (currentObj instanceof Datasource) {
                Datasource datasource = (Datasource)currentObj;
                if ("driver".equals(currentTag)) {
                    datasource.setDriver(this.getText());
                } else if ("url".equals(currentTag)) {
                    datasource.setUrl(this.getText());
                } else if ("user".equals(currentTag)) {
                    datasource.setUser(this.getText());
                } else if ("password".equals(currentTag)) {
                    datasource.setPassword(this.getText());
                } else if ("properties".equals(currentTag)) {
                    datasource.setProperties(this.getText());
                }
            } else if (currentObj instanceof Model) {
                Model model = (Model)currentObj;
                if ("sample-model".equals(currentTag)) {
                    model.setSampleModel(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDatasource(Datasource parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!("driver".equals(qName) || "url".equals(qName) || "user".equals(qName) || "password".equals(qName) || "properties".equals(qName))) {
            throw new SAXException(String.format("Element(%s) is not expected under datasource!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForFile(File parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForGroup(Group parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"table".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under group!", qName));
        }
        Table table = this.m_maker.buildTable(attributes);
        this.m_linker.onTable(parentObj, table);
        this.m_objs.push(table);
        this.m_tags.push(qName);
    }

    private void parseForJdbc(Jdbc parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("datasource".equals(qName)) {
            Datasource datasource = this.m_maker.buildDatasource(attributes);
            this.m_linker.onDatasource(parentObj, datasource);
            this.m_objs.push(datasource);
        } else if ("group".equals(qName)) {
            Group group = this.m_maker.buildGroup(attributes);
            this.m_linker.onGroup(parentObj, group);
            this.m_objs.push(group);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under jdbc!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForManifest(Manifest parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"file".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under manifest!", qName));
        }
        File file = this.m_maker.buildFile(attributes);
        this.m_linker.onFile(parentObj, file);
        this.m_objs.push(file);
        this.m_tags.push(qName);
    }

    private void parseForModel(Model parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"sample-model".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under model!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForModule(Module parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"page".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under module!", qName));
        }
        Page page = this.m_maker.buildPage(attributes);
        this.m_linker.onPage(parentObj, page);
        this.m_objs.push(page);
        this.m_tags.push(qName);
    }

    private void parseForPage(Page parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"description".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under page!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForTable(Table parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForWebapp(Webapp parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"module".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under webapp!", qName));
        }
        Module module = this.m_maker.buildModule(attributes);
        this.m_linker.onModule(parentObj, module);
        this.m_objs.push(module);
        this.m_tags.push(qName);
    }

    private void parseForWizard(Wizard parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("manifest".equals(qName)) {
            Manifest manifest = this.m_maker.buildManifest(attributes);
            this.m_linker.onManifest(parentObj, manifest);
            this.m_objs.push(manifest);
        } else if ("webapp".equals(qName)) {
            Webapp webapp = this.m_maker.buildWebapp(attributes);
            this.m_linker.onWebapp(parentObj, webapp);
            this.m_objs.push(webapp);
        } else if ("jdbc".equals(qName)) {
            Jdbc jdbc = this.m_maker.buildJdbc(attributes);
            this.m_linker.onJdbc(parentObj, jdbc);
            this.m_objs.push(jdbc);
        } else if ("model".equals(qName)) {
            Model model = this.m_maker.buildModel(attributes);
            this.m_linker.onModel(parentObj, model);
            this.m_objs.push(model);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under wizard!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("wizard".equals(qName)) {
            Wizard wizard;
            this.m_root = wizard = this.m_maker.buildWizard(attributes);
            this.m_objs.push(wizard);
            this.m_tags.push(qName);
        } else if ("manifest".equals(qName)) {
            Manifest manifest;
            this.m_root = manifest = this.m_maker.buildManifest(attributes);
            this.m_objs.push(manifest);
            this.m_tags.push(qName);
        } else if ("file".equals(qName)) {
            File file;
            this.m_root = file = this.m_maker.buildFile(attributes);
            this.m_objs.push(file);
            this.m_tags.push(qName);
        } else if ("webapp".equals(qName)) {
            Webapp webapp;
            this.m_root = webapp = this.m_maker.buildWebapp(attributes);
            this.m_objs.push(webapp);
            this.m_tags.push(qName);
        } else if ("module".equals(qName)) {
            Module module;
            this.m_root = module = this.m_maker.buildModule(attributes);
            this.m_objs.push(module);
            this.m_tags.push(qName);
        } else if ("page".equals(qName)) {
            Page page;
            this.m_root = page = this.m_maker.buildPage(attributes);
            this.m_objs.push(page);
            this.m_tags.push(qName);
        } else if ("jdbc".equals(qName)) {
            Jdbc jdbc;
            this.m_root = jdbc = this.m_maker.buildJdbc(attributes);
            this.m_objs.push(jdbc);
            this.m_tags.push(qName);
        } else if ("datasource".equals(qName)) {
            Datasource datasource;
            this.m_root = datasource = this.m_maker.buildDatasource(attributes);
            this.m_objs.push(datasource);
            this.m_tags.push(qName);
        } else if ("group".equals(qName)) {
            Group group;
            this.m_root = group = this.m_maker.buildGroup(attributes);
            this.m_objs.push(group);
            this.m_tags.push(qName);
        } else if ("table".equals(qName)) {
            Table table;
            this.m_root = table = this.m_maker.buildTable(attributes);
            this.m_objs.push(table);
            this.m_tags.push(qName);
        } else if ("model".equals(qName)) {
            Model model;
            this.m_root = model = this.m_maker.buildModel(attributes);
            this.m_objs.push(model);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof Wizard) {
                this.parseForWizard((Wizard)parent, tag, qName, attributes);
            } else if (parent instanceof Manifest) {
                this.parseForManifest((Manifest)parent, tag, qName, attributes);
            } else if (parent instanceof File) {
                this.parseForFile((File)parent, tag, qName, attributes);
            } else if (parent instanceof Webapp) {
                this.parseForWebapp((Webapp)parent, tag, qName, attributes);
            } else if (parent instanceof Module) {
                this.parseForModule((Module)parent, tag, qName, attributes);
            } else if (parent instanceof Page) {
                this.parseForPage((Page)parent, tag, qName, attributes);
            } else if (parent instanceof Jdbc) {
                this.parseForJdbc((Jdbc)parent, tag, qName, attributes);
            } else if (parent instanceof Datasource) {
                this.parseForDatasource((Datasource)parent, tag, qName, attributes);
            } else if (parent instanceof Group) {
                this.parseForGroup((Group)parent, tag, qName, attributes);
            } else if (parent instanceof Table) {
                this.parseForTable((Table)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Model)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForModel((Model)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

