/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.pom;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.maven.plugin.wizard.pom.PomDelegate;
import org.unidal.maven.plugin.wizard.pom.VersionManager;

abstract class AbstractPomBuilder
implements LogEnabled {
    protected PomDelegate m_pom = new PomDelegate(new VersionManager());
    protected Logger m_logger;

    protected Document loadPom(File pomFile) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(pomFile);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePom(File pomFile, Document doc) throws IOException {
        Format format = Format.getPrettyFormat().setIndent("   ");
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileWriter writer = new FileWriter(pomFile);){
            outputter.output(doc, (Writer)writer);
            this.m_logger.info(String.format("File(%s) updated.", pomFile.getCanonicalPath()));
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }
}

