/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.pom;

import java.io.File;
import java.io.IOException;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.unidal.lookup.annotation.Named;
import org.unidal.maven.plugin.wizard.model.entity.Group;
import org.unidal.maven.plugin.wizard.model.entity.Jdbc;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.pom.AbstractPomBuilder;

@Named
public class JdbcPomBuilder
extends AbstractPomBuilder {
    private void addDependencies(Element root, Wizard wizard) {
        Element dependencies = this.m_pom.findOrCreateChild(root, "dependencies", "build", null);
        if (!this.m_pom.checkDependency(dependencies, "org.unidal.framework", "dal-jdbc", null)) {
            this.m_pom.checkDependency(dependencies, "mysql", "mysql-connector-java", "runtime");
        }
    }

    public void build(File pomFile, Wizard wizard) throws JDOMException, IOException {
        Document doc = super.loadPom(pomFile);
        Element root = doc.getRootElement();
        this.addDependencies(root, wizard);
        this.configurePlugin(root, wizard);
        if (this.m_pom.isModified()) {
            super.savePom(pomFile, doc);
            this.m_logger.info(String.format("Added dependencies to POM file(%s).", pomFile));
            this.m_logger.info("");
            this.m_logger.info("Please run following command to setup eclipse environment:");
            this.m_logger.info("   mvn eclipse:clean eclipse:eclipse");
        }
    }

    private void configurePlugin(Element root, Wizard wizard) {
        Element build = this.m_pom.findOrCreateChild(root, "build", null, "dependencies");
        Element plugins = this.m_pom.findOrCreateChild(build, "plugins");
        Element plugin = this.m_pom.checkPlugin(plugins, "org.unidal.maven.plugins", "codegen-maven-plugin");
        Element generate = this.m_pom.checkPluginExecution(plugin, "dal-jdbc", "generate-sources", "generate jdbc files");
        Element configuration = this.m_pom.findOrCreateChild(generate, "configuration");
        Element manifestElement = this.m_pom.findOrCreateChild(configuration, "manifest");
        this.m_pom.setModified(true);
        manifestElement.setContent((Content)new CDATA(this.getManifestFiles(wizard)));
    }

    private String getManifestFiles(Wizard wizard) {
        StringBuilder sb = new StringBuilder(1024);
        String prefix = "${basedir}/src/main/resources/META-INF/dal/jdbc/";
        String indent = "                        ";
        boolean first = true;
        for (Jdbc jdbc : wizard.getJdbcs()) {
            for (Group group : jdbc.getGroups()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("\r\n");
                sb.append(indent).append(prefix).append(group.getName()).append("-manifest.xml");
            }
        }
        return sb.toString();
    }
}

