/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.pom;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.unidal.maven.plugin.wizard.dom.DomAccessor;

public class PomDelegate
extends DomAccessor {
    private static Namespace NS = Namespace.getNamespace((String)"http://maven.apache.org/POM/4.0.0");
    private VersionMapping m_versionMapping;
    private Log m_logger;

    public PomDelegate(VersionMapping versionMapping) {
        this.m_versionMapping = versionMapping;
    }

    public boolean checkDependency(Element dependencies, String groupId, String artifactId, String scope) {
        Element dependency = this.findDependency(dependencies, groupId, artifactId);
        if (dependency == null) {
            dependency = new Element("dependency", NS);
            this.createChild(dependency, "groupId", groupId);
            this.createChild(dependency, "artifactId", artifactId);
            String version = this.m_versionMapping.getVersion(groupId, artifactId);
            if (version != null) {
                this.createChild(dependency, "version", version);
            }
            if (scope != null) {
                this.createChild(dependency, "scope", scope);
            }
            dependencies.addContent((Content)dependency);
            if (this.m_logger != null) {
                this.m_logger.info((CharSequence)String.format("Dependency(%s:%s:%s) added.", groupId, artifactId, version));
            }
            return false;
        }
        return true;
    }

    public boolean checkExclusion(Element dependency, String groupId, String artifactId) {
        Element exclusions = this.findOrCreateChild(dependency, "exclusions");
        Element exclusion = this.findExclusion(exclusions, groupId, artifactId);
        if (exclusion == null) {
            exclusion = new Element("exclusion", NS);
            this.createChild(exclusion, "groupId", groupId);
            this.createChild(exclusion, "artifactId", artifactId);
            exclusions.addContent((Content)exclusion);
            return false;
        }
        return true;
    }

    public Element checkPlugin(Element plugins, String groupId, String artifactId) {
        List children = plugins.getChildren("plugin", NS);
        Element plugin = null;
        for (Element child : children) {
            String g = child.getChildText("groupId", NS);
            String a = child.getChildText("artifactId", NS);
            if (groupId != null && (groupId == null || !groupId.equals(g)) || !artifactId.equals(a)) continue;
            plugin = child;
            break;
        }
        if (plugin == null) {
            plugin = new Element("plugin", NS);
            if (groupId != null) {
                this.createChild(plugin, "groupId", groupId);
            }
            this.createChild(plugin, "artifactId", artifactId);
            String version = this.m_versionMapping.getVersion(groupId, artifactId);
            if (version != null) {
                this.createChild(plugin, "version", version);
            }
            plugins.addContent((Content)plugin);
        }
        return plugin;
    }

    public Element checkPluginExecution(Element plugin, String goal, String phase, String id) {
        Element executions = this.findOrCreateChild(plugin, "executions");
        Element execution = this.findPluginExecution(executions, id);
        if (execution == null) {
            execution = this.createChild(executions, "execution", null);
            if (id != null) {
                this.createChild(execution, "id", id);
            }
            if (phase != null) {
                this.createChild(execution, "phase", phase);
            }
            if (goal != null) {
                Element goals = this.createChild(execution, "goals", null);
                this.createChild(goals, "goal", goal);
            }
        }
        return execution;
    }

    public Document createMavenDocument() {
        Element root = new Element("project", this.getNamespace());
        Document doc = new Document(root);
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.addNamespaceDeclaration(NS);
        root.setAttribute("schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd", xsi);
        return doc;
    }

    public Element findDependency(Element dependencies, String groupId, String artifactId) {
        List children = dependencies.getChildren("dependency", NS);
        Element dependency = null;
        for (Element child : children) {
            String g = child.getChildText("groupId", NS);
            String a = child.getChildText("artifactId", NS);
            if (!groupId.equals(g) || !artifactId.equals(a)) continue;
            dependency = child;
            break;
        }
        return dependency;
    }

    public Element findExclusion(Element exclusions, String groupId, String artifactId) {
        List children = exclusions.getChildren("exclusion", NS);
        Element dependency = null;
        for (Element child : children) {
            String g = child.getChildText("groupId", NS);
            String a = child.getChildText("artifactId", NS);
            if (!groupId.equals(g) || !artifactId.equals(a)) continue;
            dependency = child;
            break;
        }
        return dependency;
    }

    public Element findPluginExecution(Element executions, String id) {
        Element execution = null;
        for (Element e : executions.getChildren()) {
            Element idElement = e.getChild("id", NS);
            if (id == null) {
                if (idElement != null && !"default".equals(idElement.getValue())) continue;
                execution = e;
                break;
            }
            if (idElement == null || !id.equals(idElement.getValue())) continue;
            execution = e;
            break;
        }
        return execution;
    }

    @Override
    protected Namespace getNamespace() {
        return NS;
    }

    public Document openMavenDocument(File pomFile) {
        try {
            return new SAXBuilder().build(pomFile);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error when opening pom file: %s!", pomFile), e);
        }
    }

    public PomDelegate setLog(Log log) {
        this.m_logger = log;
        return this;
    }

    public static interface VersionMapping {
        public String getVersion(String var1, String var2);
    }
}

