/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.pom;

import java.util.HashMap;
import java.util.Map;
import org.unidal.maven.plugin.wizard.pom.PomDelegate;

public class VersionManager
implements PomDelegate.VersionMapping {
    private Map<Entry, Entry> m_entries = new HashMap<Entry, Entry>();

    public VersionManager() {
        this.configure("org.unidal.foundation", "foundation", "6.0.0", null);
        this.configure("org.unidal.framework", "web-framework", "6.0.0", null);
        this.configure("org.unidal.test", "test-framework", "6.0.0", "test");
        this.configure("javax.servlet", "javax.servlet-api", "3.1.0", "provided");
        this.configure("mysql", "mysql-connector-java", "8.0.28", "runtime");
        this.configure("org.unidal.maven.plugins", "codegen-maven-plugin", "6.0.0", null);
        this.configure("org.unidal.maven.plugins", "plexus-maven-plugin", "6.0.0", null);
    }

    public void configure(String groupId, String artifactId, String version, String scope) {
        Entry e = new Entry(groupId, artifactId).version(version).scope(scope);
        this.m_entries.put(e, e);
    }

    @Override
    public String getVersion(String groupId, String artifactId) {
        Entry e = this.m_entries.get(new Entry(groupId, artifactId));
        if (e != null) {
            return e.m_version;
        }
        return null;
    }

    private static class Entry {
        private String m_groupId;
        private String m_artifactId;
        private String m_version;
        private String m_scope;

        public Entry(String groupId, String artifactId) {
            this.m_groupId = groupId;
            this.m_artifactId = artifactId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry d = (Entry)obj;
                return this.m_artifactId.equals(d.m_artifactId) && this.m_groupId.equals(d.m_groupId);
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.m_groupId.hashCode();
            hash = 31 * hash + this.m_artifactId.hashCode();
            return hash;
        }

        public Entry scope(String scope) {
            this.m_scope = scope;
            return this;
        }

        public String toString() {
            return "Dependency[groupId=" + this.m_groupId + ", artifactId=" + this.m_artifactId + ", version=" + this.m_version + ", scope=" + this.m_scope + "]";
        }

        public Entry version(String version) {
            this.m_version = version;
            return this;
        }
    }
}

