/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.wizard.pom;

import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.unidal.lookup.annotation.Named;
import org.unidal.maven.plugin.wizard.model.entity.Wizard;
import org.unidal.maven.plugin.wizard.pom.AbstractPomBuilder;

@Named
public class WebAppPomBuilder
extends AbstractPomBuilder {
    private void addDependencies(Element root, Wizard wizard) {
        Element dependencies = this.m_pom.findOrCreateChild(root, "dependencies", "build", null);
        if (!this.m_pom.checkDependency(dependencies, "org.unidal.framework", "web-framework", null)) {
            this.m_pom.checkDependency(dependencies, "javax.servlet", "javax.servlet-api", "provided");
            this.m_pom.checkDependency(dependencies, "org.unidal.test", "test-framework", "test");
        }
    }

    public void build(File pomFile, Wizard wizard) throws Exception {
        Document doc = super.loadPom(pomFile);
        Element root = doc.getRootElement();
        this.setPackaging(root, wizard);
        this.addDependencies(root, wizard);
        this.configurePlugin(root, wizard);
        if (this.m_pom.isModified()) {
            super.savePom(pomFile, doc);
            this.m_logger.info(String.format("Added dependencies to POM file(%s).", pomFile));
            this.m_logger.info("");
            this.m_logger.info("Please run following command to setup eclipse environment:");
            this.m_logger.info("   mvn eclipse:clean eclipse:eclipse");
        }
    }

    private void configurePlugin(Element root, Wizard wizard) {
        Element build = this.m_pom.findOrCreateChild(root, "build", null, "dependencies");
        Element plugins = this.m_pom.findOrCreateChild(build, "plugins");
        Element plexusPlugin = this.m_pom.checkPlugin(plugins, "org.unidal.maven.plugins", "plexus-maven-plugin");
        Element plexus = this.m_pom.checkPluginExecution(plexusPlugin, "plexus", null, "generate plexus component descriptor");
        Element codegenPlexusConfiguration = this.m_pom.findOrCreateChild(plexus, "configuration");
        Element className = this.m_pom.findOrCreateChild(codegenPlexusConfiguration, "className");
        className.setText(wizard.getPackage() + ".build.ComponentsConfigurator");
    }

    private void setPackaging(Element project, Wizard wizard) {
        String type;
        Element packaging = this.m_pom.findChild(project, "packaging");
        String string = type = packaging == null ? "jar" : packaging.getText();
        if (!wizard.getWebapp().isModule() && "jar".equals(type)) {
            this.m_pom.findOrCreateChild(project, "packaging", "dependencies", null).setText("war");
            this.m_logger.info(String.format("Change project packaging type from %s to war.", type));
        }
    }
}

