/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitedid.yhsm.internal.AEADCmd;
import org.unitedid.yhsm.internal.AESECBCmd;
import org.unitedid.yhsm.internal.BufferCmd;
import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.DeviceHandlerFactory;
import org.unitedid.yhsm.internal.EchoCmd;
import org.unitedid.yhsm.internal.HMACCmd;
import org.unitedid.yhsm.internal.HsmUnlockCmd;
import org.unitedid.yhsm.internal.KeyStorageUnlockCmd;
import org.unitedid.yhsm.internal.KeyStoreDecryptCmd;
import org.unitedid.yhsm.internal.LoadTemporaryKeyCmd;
import org.unitedid.yhsm.internal.MonitorExitCmd;
import org.unitedid.yhsm.internal.Nonce;
import org.unitedid.yhsm.internal.NonceGetCmd;
import org.unitedid.yhsm.internal.OATH;
import org.unitedid.yhsm.internal.RandomCmd;
import org.unitedid.yhsm.internal.RandomReseedCmd;
import org.unitedid.yhsm.internal.SystemInfoCmd;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.internal.YubikeyOtpDecodeCmd;
import org.unitedid.yhsm.utility.Utils;

public class YubiHSM {
    private final Logger log = LoggerFactory.getLogger(YubiHSM.class);
    private DeviceHandler deviceHandler;
    public static int minHashLength = 20;
    SystemInfoCmd info;

    public YubiHSM(String device, float timeout) throws YubiHSMErrorException {
        this.deviceHandler = DeviceHandlerFactory.get(device);
        this.deviceHandler.setTimeout(timeout);
        this.init();
    }

    public YubiHSM(String device) throws YubiHSMErrorException {
        this.deviceHandler = DeviceHandlerFactory.get(device);
        this.init();
    }

    public YubiHSM() throws YubiHSMErrorException {
        this.deviceHandler = DeviceHandlerFactory.get("/dev/ttyACM0");
        this.init();
    }

    public String echo(String str) throws YubiHSMErrorException {
        return EchoCmd.execute(this.deviceHandler, str);
    }

    public SystemInfoCmd getInfo() {
        return this.info;
    }

    public Map<String, String> generateAEAD(String nonce, int keyHandle, byte[] data) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return AEADCmd.generateAEAD(this.deviceHandler, nonce, keyHandle, data);
    }

    public Map<String, String> generateAEAD(String nonce, int keyHandle, String data) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return AEADCmd.generateAEAD(this.deviceHandler, nonce, keyHandle, data.getBytes());
    }

    public Map<String, String> generateRandomAEAD(String nonce, int keyHandle, int length) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return AEADCmd.generateRandomAEAD(this.deviceHandler, nonce, keyHandle, length);
    }

    public Map<String, String> generateBufferAEAD(String nonce, int keyHandle) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return AEADCmd.generateBufferAEAD(this.deviceHandler, nonce, keyHandle);
    }

    public String generateOathAEAD(String nonce, int keyHandle, String tokenSeed) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        if (tokenSeed.length() != 40) {
            throw new YubiHSMInputException("Seed is not of required length, got " + tokenSeed.length() + " but expected 40");
        }
        byte[] seed = Utils.hexToByteArray(tokenSeed);
        byte[] flag = Utils.leIntToBA(65536);
        this.loadBufferData(Utils.concatAllArrays(seed, new byte[][]{flag}), 0);
        return this.generateBufferAEAD(nonce, keyHandle).get("aead");
    }

    public boolean validateAEAD(String nonce, int keyHandle, String aead, byte[] plaintext) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return AEADCmd.validateAEAD(this.deviceHandler, nonce, keyHandle, aead, plaintext);
    }

    public boolean validateAEAD(String nonce, int keyHandle, String aead, String plaintext) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return AEADCmd.validateAEAD(this.deviceHandler, nonce, keyHandle, aead, plaintext.getBytes());
    }

    public int loadBufferData(String data, int offset) throws YubiHSMErrorException {
        return BufferCmd.loadData(this.deviceHandler, data, offset);
    }

    public int loadBufferData(byte[] data, int offset) throws YubiHSMErrorException {
        return BufferCmd.loadData(this.deviceHandler, data, offset);
    }

    public int loadRandomBufferData(int length, int offset) throws YubiHSMErrorException {
        return BufferCmd.loadRandomData(this.deviceHandler, length, offset);
    }

    public void exitMonitorDebugMode() throws YubiHSMErrorException {
        MonitorExitCmd.execute(this.deviceHandler);
    }

    public boolean loadTemporaryKey(String nonce, int keyHandle, String aead) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return LoadTemporaryKeyCmd.execute(this.deviceHandler, nonce, keyHandle, aead);
    }

    public byte[] generateHMACSHA1(byte[] bytes, int keyHandle, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        byte[] result = new byte[]{};
        byte flags = 1;
        if (toBuffer) {
            flags = (byte)(flags | 4);
        }
        for (int b = 0; b < bytes.length; b += 64) {
            if (bytes.length - b <= 64) {
                flags = (byte)(flags | 2);
            }
            result = HMACCmd.execHMACSHA1_Raw(this.deviceHandler, Utils.rangeOfByteArray(bytes, b, Math.min(bytes.length - b, 64)), keyHandle, flags);
            flags = (byte)(flags & 0xFFFFFFFE);
        }
        return result;
    }

    public Map<String, String> generateHMACSHA1(String data, int keyHandle, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.generateHMACSHA1(this.deviceHandler, data.getBytes(), keyHandle, (byte)0, last, toBuffer);
    }

    public Map<String, String> generateHMACSHA1(byte[] data, int keyHandle, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.generateHMACSHA1(this.deviceHandler, data, keyHandle, (byte)0, last, toBuffer);
    }

    public Map<String, String> generateHMACSHA1(String data, int keyHandle, byte flags, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.generateHMACSHA1(this.deviceHandler, data.getBytes(), keyHandle, flags, last, toBuffer);
    }

    public Map<String, String> generateHMACSHA1(byte[] data, int keyHandle, byte flags, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.generateHMACSHA1(this.deviceHandler, data, keyHandle, flags, last, toBuffer);
    }

    public Map<String, String> generateHMACSHA1Next(String data, int keyHandle, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.next(this.deviceHandler, data.getBytes(), keyHandle, last, toBuffer);
    }

    public Map<String, String> generateHMACSHA1Next(byte[] data, int keyHandle, boolean last, boolean toBuffer) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return HMACCmd.next(this.deviceHandler, data, keyHandle, last, toBuffer);
    }

    public String encryptAES_ECB(String plaintext, int keyHandle) throws YubiHSMErrorException, YubiHSMInputException, YubiHSMCommandFailedException {
        return AESECBCmd.encrypt(this.deviceHandler, keyHandle, plaintext);
    }

    public String decryptAES_ECB(String cipherText, int keyHandle) throws YubiHSMErrorException, YubiHSMInputException, YubiHSMCommandFailedException {
        return AESECBCmd.decrypt(this.deviceHandler, keyHandle, cipherText);
    }

    public boolean compareAES_ECB(int keyHandle, String cipherText, String plaintext) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return AESECBCmd.compare(this.deviceHandler, keyHandle, cipherText, plaintext);
    }

    public boolean unlock(String password) throws YubiHSMErrorException, YubiHSMCommandFailedException, YubiHSMInputException {
        if (this.info.getMajorVersion() == 0) {
            return this.keyStorageUnlock(password);
        }
        return this.keyStoreDecrypt(password);
    }

    public boolean keyStoreDecrypt(String key) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return KeyStoreDecryptCmd.execute(this.deviceHandler, key);
    }

    public boolean keyStorageUnlock(String password) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return KeyStorageUnlockCmd.execute(this.deviceHandler, password);
    }

    public boolean unlockOtp(String publicId, String otp) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return HsmUnlockCmd.unlockOtp(this.deviceHandler, publicId, otp);
    }

    public int validateOathHOTP(int keyHandle, String nonce, String aead, int counter, String otp, int lookAhead) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return OATH.validateHOTP(this, keyHandle, nonce, aead, counter, otp, lookAhead);
    }

    public boolean validateOathTOTP(int keyHandle, String nonce, String aead, String otp, int period, int drift, int backwardDrift, int forwardDrift) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return OATH.validateTOTP(this, keyHandle, nonce, aead, otp, period, drift, backwardDrift, forwardDrift);
    }

    public boolean validateOathTOTP(int keyHandle, String nonce, String aead, String otp) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        return this.validateOathTOTP(keyHandle, nonce, aead, otp, 30, 0, 1, 1);
    }

    public Nonce getNonce(short increment) throws YubiHSMErrorException, YubiHSMCommandFailedException {
        return NonceGetCmd.execute(this.deviceHandler, increment);
    }

    public byte[] getRandom(int bytes) throws YubiHSMErrorException, YubiHSMInputException {
        return RandomCmd.execute(this.deviceHandler, bytes);
    }

    public boolean randomReseed(String seed) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        return RandomReseedCmd.execute(this.deviceHandler, seed);
    }

    public Map<String, Integer> decodeYubikeyOtp(String publicId, int keyHandle, String aead, String otp) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        return YubikeyOtpDecodeCmd.execute(this.deviceHandler, publicId, keyHandle, aead, otp);
    }

    public boolean drainData() {
        return this.deviceHandler.drain();
    }

    public DeviceHandler getRawDevice() {
        return this.deviceHandler;
    }

    public int getMinHashLength() {
        return minHashLength;
    }

    public void setMinHashLength(int value) {
        minHashLength = value;
    }

    private void init() throws YubiHSMErrorException {
        CommandHandler.reset(this.deviceHandler);
        this.info = new SystemInfoCmd(this.deviceHandler);
    }
}

