/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm;

import java.io.Console;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.unitedid.yhsm.YubiHSM;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.ModHex;
import org.unitedid.yhsm.utility.Utils;

public class YubiHSMCmdLine {
    private static boolean debug = false;
    private static String deviceName = "/dev/ttyACM0";
    private static YubiHSM hsm;
    private static boolean useOtp;

    private YubiHSMCmdLine() {
    }

    public static void printUsage(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(80);
        help.printHelp("[-D <device>] [OPTION]...", "", options, "");
    }

    public static void runUnlock() {
        try {
            hsm = new YubiHSM(deviceName, 1.0f);
            Console in = System.console();
            if (in == null) {
                System.out.println("Failed to open system console.");
                System.exit(1);
            }
            String otp = null;
            String password = new String(in.readPassword("Please enter HSM password: ", new Object[0]));
            if (hsm.getInfo().getMajorVersion() > 0 && useOtp) {
                otp = ModHex.decode(new String(in.readPassword("Please enter admin YubiKey OTP: ", new Object[0])));
            }
            if (YubiHSMCmdLine.unlock(password, otp).booleanValue()) {
                System.out.println("YubiHSM " + deviceName + " was successfully unlocked.");
            } else {
                System.out.println("Unlock failed, bad password.");
            }
        }
        catch (YubiHSMCommandFailedException e) {
            System.out.println("Unlock command failed with the reason: " + e.getMessage());
        }
        catch (YubiHSMInputException e) {
            System.out.println("Invalid input. Password has to be in hex format.");
            if (debug) {
                System.out.println(e);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid input. Password has to be in hex format.");
        }
        catch (YubiHSMErrorException e) {
            System.out.println("An error has occurred: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "This usage information");
        options.addOption("d", "debug", false, "Debug output");
        options.addOption("D", "device", true, "YubiHSM device name, default is /dev/ttyACM0");
        options.addOption("u", "unlock-hsm", false, "Unlock YubiHSM key storage");
        options.addOption("n", "no-otp", false, "Don't ask for OTP");
        if (args.length < 1) {
            YubiHSMCmdLine.printUsage(options);
            System.exit(0);
        }
        try {
            CommandLine cmdLine = parser.parse(options, args);
            if (cmdLine.hasOption("h")) {
                YubiHSMCmdLine.printUsage(options);
                System.exit(0);
            }
            if (cmdLine.hasOption("d")) {
                debug = true;
            }
            if (cmdLine.hasOption("D")) {
                deviceName = cmdLine.getOptionValue("D");
            }
            if (cmdLine.hasOption("u") || cmdLine.hasOption("n")) {
                if (cmdLine.hasOption("n")) {
                    useOtp = false;
                }
                YubiHSMCmdLine.runUnlock();
            } else {
                YubiHSMCmdLine.printUsage(options);
            }
        }
        catch (ParseException e) {
            System.out.println("Bad command arguments.");
            YubiHSMCmdLine.printUsage(options);
            System.exit(1);
        }
        System.exit(0);
    }

    private static Boolean unlock(String password, String otp) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        if (hsm.getInfo().getMajorVersion() == 0) {
            if (hsm.keyStorageUnlock(password)) {
                return true;
            }
        } else if (useOtp) {
            if (otp == null || otp.isEmpty()) {
                throw new IllegalArgumentException("Invalid OTP");
            }
            String publicId = Utils.getYubiKeyPublicId(otp);
            String key = Utils.getYubiKeyOtp(otp);
            if (hsm.keyStoreDecrypt(password) && hsm.unlockOtp(publicId, key)) {
                return true;
            }
        } else if (hsm.keyStoreDecrypt(password)) {
            return true;
        }
        return false;
    }

    static {
        useOtp = true;
    }
}

