/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.util.HashMap;
import java.util.Map;
import org.unitedid.yhsm.YubiHSM;
import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class AEADCmd {
    private AEADCmd() {
    }

    public static Map<String, String> generateAEAD(DeviceHandler device, String nonce, int keyHandle, byte[] data) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        byte[] nonceBA = Utils.validateNonce(Utils.hexToByteArray(nonce), true);
        byte[] newdata = Utils.validateByteArray("data", data, 0, 0, YubiHSM.minHashLength);
        byte[] cmdBuffer = Utils.concatAllArrays(nonceBA, Utils.leIntToBA(keyHandle), Utils.addLengthToData(newdata));
        byte[] result = CommandHandler.execute(device, (byte)1, cmdBuffer, true);
        return AEADCmd.parseResult(result, nonce, keyHandle, (byte)1);
    }

    public static Map<String, String> generateRandomAEAD(DeviceHandler device, String nonce, int keyHandle, int size) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        byte[] nonceBA = Utils.validateNonce(Utils.hexToByteArray(nonce), true);
        byte[] len = new byte[]{(byte)(size << 24 >> 24)};
        byte[] cmdBuffer = Utils.concatAllArrays(nonceBA, Utils.leIntToBA(keyHandle), len);
        byte[] result = CommandHandler.execute(device, (byte)3, cmdBuffer, true);
        return AEADCmd.parseResult(result, nonce, keyHandle, (byte)3);
    }

    public static Map<String, String> generateBufferAEAD(DeviceHandler device, String nonce, int keyHandle) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        byte[] nonceBA = Utils.validateNonce(Utils.hexToByteArray(nonce), true);
        byte[] cmdBuffer = Utils.concatAllArrays(nonceBA, new byte[][]{Utils.leIntToBA(keyHandle)});
        byte[] result = CommandHandler.execute(device, (byte)2, cmdBuffer, true);
        return AEADCmd.parseResult(result, nonce, keyHandle, (byte)2);
    }

    public static boolean validateAEAD(DeviceHandler device, String nonce, int keyHandle, String aead, byte[] plaintext) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        byte[] aeadBA = Utils.hexToByteArray(aead);
        byte[] plainBA = Utils.validateByteArray("plaintext", plaintext, 0, aeadBA.length - 8, YubiHSM.minHashLength);
        byte[] plainAndAead = Utils.concatAllArrays(plainBA, new byte[][]{aeadBA});
        if (plainAndAead.length > 80) {
            throw new YubiHSMInputException("Plaintext+aead too long");
        }
        byte[] nonceBA = Utils.validateNonce(Utils.hexToByteArray(nonce), true);
        byte[] cmdBuffer = Utils.concatAllArrays(nonceBA, Utils.leIntToBA(keyHandle), Utils.addLengthToData(plainAndAead));
        byte[] result = CommandHandler.execute(device, (byte)4, cmdBuffer, true);
        return AEADCmd.parseValidationResult(result, nonce, keyHandle);
    }

    private static Map<String, String> parseResult(byte[] data, String nonce, int keyHandle, byte command) throws YubiHSMCommandFailedException, YubiHSMErrorException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (data[10] != -128) {
            throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString(command) + " failed: " + Defines.getCommandStatus(data[10]));
        }
        byte[] aead = Utils.rangeOfByteArray(data, 12, data[11]);
        Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 6, 4), Utils.leIntToBA(keyHandle));
        result.put("nonce", Utils.validateCmdResponseString("nonce", Utils.byteArrayToHex(Utils.rangeOfByteArray(data, 0, 6)), nonce));
        result.put("aead", Utils.byteArrayToHex(aead));
        return result;
    }

    private static boolean parseValidationResult(byte[] data, String nonce, int keyHandle) throws YubiHSMCommandFailedException, YubiHSMErrorException {
        Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 6, 4), Utils.leIntToBA(keyHandle));
        Utils.validateCmdResponseString("nonce", Utils.byteArrayToHex(new String(data, 0, 6).getBytes()), nonce);
        if (data[10] == -128) {
            return true;
        }
        if (data[10] == -117) {
            return false;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)4) + " failed: " + Defines.getCommandStatus(data[10]));
    }
}

