/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.util.HashMap;
import java.util.Map;
import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class HMACCmd {
    private HMACCmd() {
    }

    public static Map<String, String> generateHMACSHA1(DeviceHandler deviceHandler, byte[] data, int keyHandle, byte flags, boolean last, boolean toBuffer) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        byte[] dataBA = Utils.validateByteArray("data", data, 90, 0, 0);
        if (flags == 0) {
            flags = 1;
            if (last) {
                flags = (byte)(flags | 2);
            }
            if (toBuffer) {
                flags = (byte)(flags | 4);
            }
        }
        byte[] flagsBA = new byte[]{flags};
        byte[] cmdBuffer = Utils.concatAllArrays(Utils.leIntToBA(keyHandle), flagsBA, Utils.addLengthToData(dataBA));
        byte[] result = CommandHandler.execute(deviceHandler, (byte)16, cmdBuffer, true);
        return HMACCmd.parseResult(result, keyHandle, last);
    }

    public static byte[] execHMACSHA1_Raw(DeviceHandler deviceHandler, byte[] data, int keyHandle, byte flags) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        byte[] dataBA = Utils.validateByteArray("data", data, 64, 0, 0);
        byte[] flagsBA = new byte[]{flags};
        byte[] cmdBuffer = Utils.concatAllArrays(Utils.leIntToBA(keyHandle), flagsBA, Utils.addLengthToData(dataBA));
        byte[] result = CommandHandler.execute(deviceHandler, (byte)16, cmdBuffer, true);
        boolean isLast = (flags & 2) == 2;
        return HMACCmd.parseResultRaw(result, keyHandle, isLast);
    }

    public static Map<String, String> next(DeviceHandler deviceHandler, byte[] data, int keyHandle, boolean last, boolean toBuffer) throws YubiHSMCommandFailedException, YubiHSMErrorException, YubiHSMInputException {
        byte flags = last ? (byte)2 : 0;
        if (toBuffer) {
            flags = (byte)(flags | 4);
        }
        byte[] flagsBA = new byte[]{flags};
        byte[] cmdBuffer = Utils.concatAllArrays(Utils.leIntToBA(keyHandle), flagsBA, Utils.addLengthToData(data));
        byte[] result = CommandHandler.execute(deviceHandler, (byte)16, cmdBuffer, true);
        return HMACCmd.parseResult(result, keyHandle, last);
    }

    private static Map<String, String> parseResult(byte[] data, int keyHandle, boolean last) throws YubiHSMErrorException, YubiHSMCommandFailedException, YubiHSMInputException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (data[4] == -128) {
            Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 0, 4), Utils.leIntToBA(keyHandle));
            if (last) {
                result.put("status", "OK");
                result.put("hash", Utils.byteArrayToHex(Utils.rangeOfByteArray(data, 6, data[5])));
            } else {
                byte[] zeroHash = new byte[]{0};
                zeroHash = Utils.validateByteArray("zeroHash", zeroHash, 0, 0, 20);
                result.put("status", "Expect more data");
                result.put("hash", Utils.byteArrayToHex(zeroHash));
            }
        } else {
            throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)16) + " failed: " + Defines.getCommandStatus(data[4]));
        }
        return result;
    }

    private static byte[] parseResultRaw(byte[] data, int keyHandle, boolean last) throws YubiHSMErrorException, YubiHSMCommandFailedException, YubiHSMInputException {
        if (data[4] == -128) {
            Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 0, 4), Utils.leIntToBA(keyHandle));
            if (last) {
                return Utils.rangeOfByteArray(data, 6, data[5]);
            }
            byte[] zeroHash = new byte[]{0};
            zeroHash = Utils.validateByteArray("zeroHash", zeroHash, 0, 0, 20);
            return zeroHash;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)16) + " failed: " + Defines.getCommandStatus(data[4]));
    }
}

