/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class LoadTemporaryKeyCmd {
    private LoadTemporaryKeyCmd() {
    }

    public static boolean execute(DeviceHandler device, String nonce, int keyHandle, String aead) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] nonceBA = Utils.validateNonce(Utils.hexToByteArray(nonce), true);
        int maxAeadLength = 44;
        byte[] aeadBA = Utils.validateByteArray("aead", Utils.hexToByteArray(aead), maxAeadLength, 0, 0);
        byte[] cmdBuffer = Utils.concatAllArrays(nonceBA, Utils.leIntToBA(keyHandle), Utils.addLengthToData(aeadBA));
        byte[] result = CommandHandler.execute(device, (byte)17, cmdBuffer, true);
        return LoadTemporaryKeyCmd.parseResult(result, nonce, keyHandle);
    }

    private static boolean parseResult(byte[] result, String nonce, int keyHandle) throws YubiHSMErrorException, YubiHSMCommandFailedException {
        if (result[10] == -128) {
            Utils.validateCmdResponseString("nonce", Utils.byteArrayToHex(Utils.rangeOfByteArray(result, 0, 6)), nonce);
            Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(result, 6, 4), Utils.leIntToBA(keyHandle));
            return true;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)17) + " failed: " + Defines.getCommandStatus(result[10]));
    }
}

