/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.utility.Utils;

public class SystemInfoCmd {
    private int majorVersion;
    private int minorVersion;
    private int buildVersion;
    private String protocol;
    private String sysId;

    public SystemInfoCmd(DeviceHandler device) throws YubiHSMErrorException {
        this.parseResult(CommandHandler.execute(device, (byte)38, new byte[0], true));
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getVersion() {
        return String.format("%s.%s.%s", this.majorVersion, this.minorVersion, this.buildVersion);
    }

    public String getSystemInfo() {
        return String.format("Version %s.%s.%s  Protocol=%s  SysId: %s", this.majorVersion, this.minorVersion, this.buildVersion, this.protocol, this.sysId);
    }

    private void parseResult(byte[] data) {
        this.majorVersion = new Integer(String.valueOf(data[0]));
        this.minorVersion = new Integer(String.valueOf(data[1]));
        this.buildVersion = new Integer(String.valueOf(data[2]));
        this.protocol = String.valueOf(data[3]);
        this.sysId = "0x" + Utils.byteArrayToHex(new String(data, 4, 12).getBytes());
    }
}

