/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.utility.Utils;

public class BufferCmd {
    private BufferCmd() {
    }

    public static int loadData(DeviceHandler device, String data, int offset) throws YubiHSMErrorException {
        int dataLength = data.getBytes().length;
        byte[] off = new byte[]{(byte)(offset << 24 >> 24)};
        byte[] cmdBuffer = Utils.concatAllArrays(off, new byte[][]{Utils.addLengthToData(data.getBytes())});
        byte[] result = CommandHandler.execute(device, (byte)32, cmdBuffer, true);
        return BufferCmd.parseResult(offset, dataLength, result);
    }

    public static int loadData(DeviceHandler device, byte[] data, int offset) throws YubiHSMErrorException {
        int dataLength = data.length;
        byte[] off = new byte[]{(byte)(offset << 24 >> 24)};
        byte[] cmdBuffer = Utils.concatAllArrays(off, new byte[][]{Utils.addLengthToData(data)});
        byte[] result = CommandHandler.execute(device, (byte)32, cmdBuffer, true);
        return BufferCmd.parseResult(offset, dataLength, result);
    }

    public static int loadRandomData(DeviceHandler device, int length, int offset) throws YubiHSMErrorException {
        byte[] cmdBuffer = new byte[]{(byte)(offset << 24 >> 24), (byte)(length << 24 >> 24)};
        byte[] result = CommandHandler.execute(device, (byte)33, cmdBuffer, true);
        return BufferCmd.parseResult(offset, length, result);
    }

    private static int parseResult(int offset, int dataLength, byte[] data) throws YubiHSMErrorException {
        byte count = data[0];
        if (offset == 0 && count != dataLength) {
            throw new YubiHSMErrorException("Incorrect number of bytes in buffer, got " + count + ", expected " + dataLength);
        }
        return count;
    }
}

