/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Defines {
    public static final byte YSM_MAX_PKT_SIZE = 96;
    public static final int YSM_AEAD_NONCE_SIZE = 6;
    public static final int YSM_AEAD_MAC_SIZE = 8;
    public static final int YSM_DATA_BUF_SIZE = 64;
    public static final int YSM_MAX_KEY_SIZE = 32;
    public static final int YSM_AEAD_MAX_SIZE = 72;
    public static final int YSM_SHA1_HASH_SIZE = 20;
    public static final int YSM_PUBLIC_ID_SIZE = 6;
    public static final int YSM_OTP_SIZE = 16;
    public static final int YSM_BLOCK_SIZE = 16;
    public static final int UID_SIZE = 6;
    public static final int KEY_SIZE = 16;
    public static final int YSM_CTR_DRBG_SEED_SIZE = 32;
    public static final int YSM_YUBIKEY_AEAD_SIZE = 30;
    public static final byte YSM_HMAC_SHA1_RESET = 1;
    public static final byte YSM_HMAC_SHA1_FINAL = 2;
    public static final byte YSM_HMAC_SHA1_TO_BUFFER = 4;
    public static final byte YSM_NULL = 0;
    public static final byte YSM_AEAD_GENERATE = 1;
    public static final byte YSM_BUFFER_AEAD_GENERATE = 2;
    public static final byte YSM_RANDOM_AEAD_GENERATE = 3;
    public static final byte YSM_AEAD_DECRYPT_CMP = 4;
    public static final byte YSM_DB_YUBIKEY_AEAD_STORE = 5;
    public static final byte YSM_AEAD_YUBIKEY_OTP_DECODE = 6;
    public static final byte YSM_DB_OTP_VALIDATE = 7;
    public static final byte YSM_AES_ECB_BLOCK_ENCRYPT = 13;
    public static final byte YSM_AES_ECB_BLOCK_DECRYPT = 14;
    public static final byte YSM_AES_ECB_BLOCK_DECRYPT_CMP = 15;
    public static final byte YSM_HMAC_SHA1_GENERATE = 16;
    public static final byte YSM_TEMP_KEY_LOAD = 17;
    public static final byte YSM_BUFFER_LOAD = 32;
    public static final byte YSM_BUFFER_RANDOM_LOAD = 33;
    public static final byte YSM_NONCE_GET = 34;
    public static final byte YSM_ECHO = 35;
    public static final byte YSM_RANDOM_GENERATE = 36;
    public static final byte YSM_RANDOM_RESEED = 37;
    public static final byte YSM_SYSTEM_INFO_QUERY = 38;
    public static final byte YSM_KEY_STORAGE_UNLOCK = 39;
    public static final byte YSM_HSM_UNLOCK = 40;
    public static final byte YSM_KEY_STORE_DECRYPT = 41;
    public static final byte YSM_MONITOR_EXIT = 127;
    public static final byte YSM_TEMP_KEY_HANDLE = -1;
    public static final Map<Integer, String> COMMAND_TO_STRING = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(0, "YSM_NULL");
            this.put(1, "YSM_AEAD_GENERATE");
            this.put(2, "YSM_BUFFER_AEAD_GENERATE");
            this.put(3, "YSM_RANDOM_AEAD_GENERATE");
            this.put(4, "YSM_AEAD_DECRYPT_CMP");
            this.put(5, "YSM_DB_YUBIKEY_AEAD_STORE");
            this.put(6, "YSM_AEAD_YUBIKEY_OTP_DECODE");
            this.put(7, "YSM_DB_OTP_VALIDATE");
            this.put(13, "YSM_AES_ECB_BLOCK_ENCRYPT");
            this.put(14, "YSM_AES_ECB_BLOCK_DECRYPT");
            this.put(15, "YSM_AES_ECB_BLOCK_DECRYPT_CMP");
            this.put(16, "YSM_HMAC_SHA1_GENERATE");
            this.put(17, "YSM_TEMP_KEY_LOAD");
            this.put(32, "YSM_BUFFER_LOAD");
            this.put(33, "YSM_BUFFER_RANDOM_LOAD");
            this.put(34, "YSM_NONCE_GET");
            this.put(35, "YSM_ECHO");
            this.put(36, "YSM_RANDOM_GENERATE");
            this.put(37, "YSM_RANDOM_RESEED");
            this.put(38, "YSM_SYSTEM_INFO_QUERY");
            this.put(39, "YSM_KEY_STORAGE_UNLOCK");
            this.put(40, "YSM_HSM_UNLOCK");
            this.put(41, "YSM_KEY_STORE_DECRYPT");
        }
    });
    public static final Map<Integer, String> COMMAND_TO_STATUS = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(128, "YSM_STATUS_OK");
            this.put(129, "YSM_KEY_HANDLE_INVALID");
            this.put(130, "YSM_AEAD_INVALID");
            this.put(131, "YSM_OTP_INVALID");
            this.put(132, "YSM_OTP_REPLAY");
            this.put(133, "YSM_ID_DUPLICATE");
            this.put(134, "YSM_ID_NOT_FOUND");
            this.put(135, "YSM_DB_FULL");
            this.put(136, "YSM_MEMORY_ERROR");
            this.put(137, "YSM_FUNCTION_DISABLED");
            this.put(138, "YSM_KEY_STORAGE_LOCKED");
            this.put(139, "YSM_MISMATCH");
            this.put(140, "YSM_INVALID_PARAMETER");
        }
    });
    public static final byte YSM_STATUS_OK = -128;
    public static final byte YSM_RESPONSE = -128;
    public static final byte YSM_OTP_INVALID = -125;
    public static final byte YSM_MISMATCH = -117;
    public static final byte YSM_KEY_STORAGE_LOCKED = -118;

    private Defines() {
    }

    public static final String getCommandString(byte b) {
        return COMMAND_TO_STRING.get(b);
    }

    public static final String getCommandStatus(byte b) {
        return COMMAND_TO_STATUS.get(b & 0xFF);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

