/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.io.IOException;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.utility.Utils;

public class DeviceHandler {
    private final Logger log = LoggerFactory.getLogger(DeviceHandler.class);
    private SerialPort device;
    private int readBytes = 0;
    private int writtenBytes = 0;
    private float timeout = 0.5f;

    DeviceHandler(String deviceName) throws YubiHSMErrorException {
        this.device = new SerialPort(deviceName);
        try {
            this.device.openPort();
            this.device.setParams(115200, 8, 1, 0);
            this.device.setFlowControlMode(0);
        }
        catch (SerialPortException e) {
            throw new YubiHSMErrorException("Failed to open device " + deviceName, e);
        }
    }

    public void write(byte[] data) {
        try {
            this.writtenBytes += data.length;
            this.device.writeBytes(data);
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    public byte[] read(int readNumBytes) {
        byte[] data = new byte[readNumBytes];
        try {
            data = this.device.readBytes(readNumBytes);
            this.readBytes += data.length;
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
        return data;
    }

    public int available() {
        try {
            return this.device.getInputBufferBytesCount();
        }
        catch (SerialPortException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean drain() {
        byte[] buffer = new byte[]{};
        while (this.available() > 0) {
            byte[] b = this.read(1);
            if ((char)b[0] == '\r') {
                this.log.info("Drained: {}", (Object)new String(buffer, 0, buffer.length));
                buffer = new byte[]{};
                continue;
            }
            buffer = Utils.concatAllArrays(buffer, new byte[][]{b});
        }
        return true;
    }

    public void flush() throws IOException {
        try {
            this.device.purgePort(12);
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    public float getTimeout() {
        return this.timeout;
    }

    public void setTimeout(float timeout) {
        this.timeout = timeout;
    }

    public int getReadBytes() {
        return this.readBytes;
    }

    public int getWrittenBytes() {
        return this.writtenBytes;
    }

    public String getPortName() {
        return this.device.getPortName();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.device.closePort();
        }
        finally {
            super.finalize();
        }
    }
}

