/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class HsmUnlockCmd {
    private HsmUnlockCmd() {
    }

    public static boolean unlockOtp(DeviceHandler device, String publicId, String otp) throws YubiHSMErrorException, YubiHSMInputException, YubiHSMCommandFailedException {
        byte[] idBA = Utils.validateByteArray("publicId", Utils.hexToByteArray(publicId), 0, 6, 6);
        byte[] otpBA = Utils.validateByteArray("otp", Utils.hexToByteArray(otp), 0, 16, 16);
        byte[] payload = Utils.concatAllArrays(idBA, new byte[][]{otpBA});
        return HsmUnlockCmd.parseResult(CommandHandler.execute(device, (byte)40, payload, true));
    }

    private static boolean parseResult(byte[] result) throws YubiHSMCommandFailedException {
        if (result[0] == -128) {
            return true;
        }
        if (result[0] == -125) {
            return false;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)40) + " failed: " + Defines.getCommandStatus(result[0]));
    }
}

