/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class KeyStorageUnlockCmd {
    private KeyStorageUnlockCmd() {
    }

    public static boolean execute(DeviceHandler device, String password) throws YubiHSMErrorException, YubiHSMInputException, YubiHSMCommandFailedException {
        byte[] pw = Utils.hexToByteArray(password);
        byte[] passwordBA = Utils.validateByteArray("password", pw, 16, 0, 16);
        return KeyStorageUnlockCmd.parseResult(CommandHandler.execute(device, (byte)39, passwordBA, true));
    }

    private static boolean parseResult(byte[] result) throws YubiHSMCommandFailedException {
        if (result[0] == -128) {
            return true;
        }
        if (result[0] == -118) {
            return false;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)39) + " failed: " + Defines.getCommandStatus(result[0]));
    }
}

