/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.text.DecimalFormat;
import java.util.Arrays;
import org.unitedid.yhsm.YubiHSM;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.IntRange;
import org.unitedid.yhsm.utility.Utils;

public class OATH {
    private OATH() {
    }

    public static synchronized String HOTP(YubiHSM hsm, int keyHandle, String nonce, String aead, int counter, String otp) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        int otpLength = otp.trim().length();
        if (otpLength < 6 || otpLength > 8) {
            throw new YubiHSMInputException("OTP not of required length, should be between 6-8 digits long but was " + otpLength);
        }
        hsm.loadTemporaryKey(nonce, keyHandle, aead);
        String hmac = hsm.generateHMACSHA1(Utils.longToByteArray(counter), -1, true, false).get("hash");
        String code = OATH.truncate(hmac, otpLength);
        return code;
    }

    public static int validateHOTP(YubiHSM hsm, int keyHandle, String nonce, String aead, int counter, String otp, int lookAhead) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        lookAhead += counter;
        while (counter < lookAhead) {
            if (OATH.HOTP(hsm, keyHandle, nonce, aead, counter, otp).equals(otp)) {
                return counter + 1;
            }
            ++counter;
        }
        return 0;
    }

    public static boolean validateTOTP(YubiHSM hsm, int keyHandle, String nonce, String aead, String otp, int period, int drift, int backwardDrift, int forwardDrift) throws YubiHSMInputException, YubiHSMCommandFailedException, YubiHSMErrorException {
        long time = System.currentTimeMillis() / 1000L;
        int window = -((int)(time / (long)period));
        for (int i : new IntRange(Math.max(window, -backwardDrift), forwardDrift + 1)) {
            int timeDrift = (drift + i) * period;
            int t = (int)((time + (long)timeDrift) / (long)period);
            if (!OATH.HOTP(hsm, keyHandle, nonce, aead, t, otp).equals(otp)) continue;
            return true;
        }
        return false;
    }

    public static String truncate(String hmac, int otpLength) throws YubiHSMInputException {
        byte[] hmacBA = Utils.hexToByteArray(hmac);
        Utils.validateByteArray("hmacBA", hmacBA, 0, 20, 0);
        int offset = hmacBA[19] & 0xF;
        int binCode = (hmacBA[offset] & 0x7F) << 24 | (hmacBA[offset + 1] & 0xFF) << 16 | (hmacBA[offset + 2] & 0xFF) << 8 | hmacBA[offset + 3] & 0xFF;
        char[] zeros = new char[otpLength];
        Arrays.fill(zeros, '0');
        DecimalFormat decimalFormat = new DecimalFormat(String.valueOf(zeros));
        return decimalFormat.format((double)binCode % Math.pow(10.0, otpLength));
    }
}

