/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class RandomCmd {
    private RandomCmd() {
    }

    public static byte[] execute(DeviceHandler device, int bytes) throws YubiHSMErrorException, YubiHSMInputException {
        if (bytes > 0 && bytes > 95) {
            throw new YubiHSMInputException("'Bytes' int too large, expected less than or equal to 95 but got " + bytes);
        }
        byte[] cmdBuffer = new byte[]{(byte)bytes};
        byte[] result = CommandHandler.execute(device, (byte)36, cmdBuffer, true);
        return RandomCmd.parseResult(result);
    }

    private static byte[] parseResult(byte[] data) {
        byte bytes = data[0];
        return Utils.rangeOfByteArray(data, 1, bytes);
    }
}

