/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.util.HashMap;
import java.util.Map;
import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class YubikeyOtpDecodeCmd {
    private YubikeyOtpDecodeCmd() {
    }

    public static Map<String, Integer> execute(DeviceHandler device, String publicId, int keyHandle, String aead, String otp) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] publicIdBA = Utils.validateNonce(Utils.hexToByteArray(publicId), true);
        byte[] otpBA = Utils.validateByteArray("otp", Utils.hexToByteArray(otp), 0, 16, 0);
        byte[] aeadBA = Utils.validateByteArray("aead", Utils.hexToByteArray(aead), 0, 30, 0);
        byte[] cmdBuffer = Utils.concatAllArrays(publicIdBA, Utils.leIntToBA(keyHandle), otpBA, aeadBA);
        byte[] result = CommandHandler.execute(device, (byte)6, cmdBuffer, true);
        return YubikeyOtpDecodeCmd.parseResult(result, publicIdBA, keyHandle);
    }

    private static Map<String, Integer> parseResult(byte[] data, byte[] publicIdBA, int keyHandle) throws YubiHSMCommandFailedException, YubiHSMErrorException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        byte status = data[16];
        if (status != -128) {
            throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)6) + " failed: " + Defines.getCommandStatus(status));
        }
        Utils.validateCmdResponseBA("publicId", Utils.rangeOfByteArray(data, 0, 6), publicIdBA);
        Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 6, 4), Utils.leIntToBA(keyHandle));
        int useCtr = Utils.leBAToBeShort(Utils.rangeOfByteArray(data, 10, 2));
        int sessionCtr = data[12] & 0xFF;
        int timestampHigh = data[13] & 0xFF;
        int timestampLow = Utils.leBAToBeShort(Utils.rangeOfByteArray(data, 14, 2));
        result.put("useCtr", useCtr);
        result.put("sessionCtr", sessionCtr);
        result.put("tsHigh", timestampHigh);
        result.put("tsLow", timestampLow);
        return result;
    }
}

